#include "mbed.h"
#include "AbitUSBModem.h"
#include "TinyHTTP.h"
#include <new>

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

void callback (char *buf, int len) {
    buf[len] = 0;
    printf(buf);
}

void test(void const*) 
{
    AbitUSBModem modem;

    printf("connect\r\n");
    int ret = modem.connect("prin", "prin");
    if(ret) {
      printf("Could not connect\r\n");
      return;
    }

    printf("IP Address %s\r\n", modem.getIPAddress());

    //GET data
    printf("Trying to fetch page...\r\n");
    httpRequest(METHOD_GET, "developer.mbed.org", 80, "/media/uploads/phsfan/hello.txt", NULL, NULL, callback);
    printf("\r\n");

    Thread::wait(1000);
    printf("exit\r\n");
    modem.disconnect();  
}

int main()
{
    pc.baud(115200); 
    printf("** PHS\r\n");

    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    while(1) {
        myled = !myled;
        Thread::wait(1000);  
    }
}
