/* AbitUSBModem.h */
/* Modified by 2015 phsfan
 *  for ABIT SMA-01
 */
/* VodafoneUSBModem.h */
/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _ABITUSBMODEM_H_
#define _ABITUSBMODEM_H_

#include "core/fwk.h"

#include "USBHostPhs.h"
#include "at/ATCommandsInterface.h"
#include "serial/usb/USBSerialStream.h"
#include "ip/PPPIPInterface.h"
#include "sms/SMSInterface.h"

class AbitUSBModem {
public:
  AbitUSBModem ();

  /** Open a 3G internet connection
      @return 0 on success, error code on failure
  */
  int connect(const char* user = NULL, const char* password = NULL);

  /** Close the internet connection
     @return 0 on success, error code on failure
  */
  int disconnect();

  /** Send a SM
     @param number The receiver's phone number
     @param message The message to send
     @return 0 on success, error code on failure
   */
  int sendSM(const char* number, const char* message);

  /** Receive a SM
     @param number Pointer to a buffer to store the sender's phone number (must be at least 17 characters-long, including the sapce for the null-terminating char)
     @param message Pointer to a buffer to store the the incoming message
     @param maxLength Maximum message length that can be stored in buffer (including null-terminating character)
     @return 0 on success, error code on failure
   */
  int getSM(char* number, char* message, size_t maxLength);

  /** Get the IP address of a connected device
      @return A pointer to a string containing the IP address.
  */
  char* getIPAddress();

protected:
  int init();

private:
  USBHostPhs m_dongle;          //< Interface to USB connected WAN dongle

  USBSerialStream m_pppStream; //< Serial interface to PPP channel on modem

  ATCommandsInterface m_at;    //< Interface to AT commands processing

  SMSInterface m_sms;          //< Interface to SMS manager (send/receive etc)

  PPPIPInterface m_ppp;        //< Interface to PPP conection manager (IP assignment etc)

  bool m_dongleConnected; //< Is the dongle physically connected (does the USB stack respond)? true/false
  bool m_ipInit;          //< Has PPIPInterface object (m_ppp) been initialised? true/false
  bool m_smsInit;         //< Has SMSInterface object (m_sms) been initialised? true/false
  bool m_atOpen;          //< Is the interface to the ATCommandsInterface open? true/false

};

#endif
