#include "mbed.h"
#include "AbitModemInterface.h"
#include <new>
#include "TinyHTTP.h"

//#define BAUD 120000
#define BAUD 9600

Serial pc(USBTX, USBRX);
DigitalOut rts(p11);

void no_memory () {
    error("no_memory\r\n");
    exit(-1);
}

void onrecv (char *buf, int len) {
    int i;
    pc.printf("recv: ");
    for (i = 0; i < len; i ++) {
        pc.putc(buf[i]);
    }
}

void ppp(void const*) // PPP
{
    AbitModemInterface modem(p13, p14, NC, NC, p12, BAUD); // tx, rx, cts, rtx, reset

    printf("connect\r\n");
    int ret = modem.connect("prin", "prin");
    if(ret) {
      printf("Could not connect\r\n");
      return;
    }

    printf("IP Address %s\r\n", modem.getIPAddress());

    //GET data
    printf("Trying to fetch page...\r\n");
    httpRequest(METHOD_GET, "developer.mbed.org", 80, "/media/uploads/phsfan/hello.txt", NULL, NULL, &onrecv);
    printf("\r\n");

    Thread::wait(5000);

    printf("exit\r\n");
    modem.disconnect();  
}

void sm(void const*) // short mail (SMS)
{
    AbitModemInterface modem(p13, p14, NC, NC, p12, BAUD); // tx, rx, cts, rtx, reset

    modem.sendSM("07012345678", "Hello");

    while(true)
    {
        char num[17];
        char msg[64];

        int ret = modem.getSM(num, msg, 64);
        if (!ret) {
          printf("%s : %s\n", num, msg);
        }
    
        Thread::wait(3000);
    }
}

int main() {
  set_new_handler(no_memory);

  pc.baud(115200); 
  pc.printf("** PHS\r\n");
  Thread::wait(1000);  
  rts = 0;

  Thread testTask(ppp, NULL, osPriorityNormal, 1024 * 4);
//  Thread smTask(sm, NULL, osPriorityNormal, 1024 * 4);
  DigitalOut led(LED1);
  while(1)
  {
    led=!led;
    Thread::wait(1000);  
  }
}

extern "C"
void HardFault_Handler() {
    error("Hard Fault!\r\n");
}
