//Written by Todd Clark
#include "mbed.h"
#include "lcdOut.h"
#include "sensor.h"
#include "light.h"
#include "convertToBAC.h"
#include "switch.h"

BusOut onboardLED {LED1,LED2,LED3,LED4}; 
InterruptIn button(p18); 
Timer debounce; 
Ticker reset;

bool overLimit;
bool lightsOn = false;

bool isOverLimit(float out, bool isUtahMode){
    float legalLimitBAC = (isUtahMode) ? 0.05 : 0.08;
    return (out < legalLimitBAC) ? false : true;
}

void resetLights(){
    lightsOn = false;
    turnOff();
    resetDisplay();
    onboardLED = 0x0; 
}

void runTest(){
    reset.attach(&resetLights, 30);
    bool isUtahMode = getUtahMode();
    float input = takeReading();
    float out = getBAC(input);
    overLimit = isOverLimit(out, isUtahMode);
    displayOut(out, isUtahMode);
}

void toggle(){
    if (debounce.read_ms()>200){ 
        runTest();
        lightsOn = true;
        debounce.reset(); 
    }
}

void initialize(){
    debounce.start();
    button.rise(&toggle); 
} 

int main(){
    float delay = 0.1;
    displayOut(-1.0, false);
    while(1){
        initialize();
        if(overLimit && lightsOn){
            changeBlue();
            onboardLED = 0x1;
            wait(delay);
            changeRed();
            onboardLED = 0x2;
            wait(delay);
            changeBlue();
            onboardLED = 0x4;
            wait(delay);
            changeRed();
            onboardLED = 0x8;
        }
        else if(lightsOn){
            changeGreen();
            onboardLED = 0x0;
        }
        else{
            turnOff();
            onboardLED = 0x0;   
        }
        wait(delay);
    }
}


