//Written by Todd Clark
#include "lcdOut.h"

uLCD_4DGL uLCD(p9,p10,p11); //Set up serial bus for LCD screen as an object using code library for LCD from https://os.mbed.com/users/sparkfun/code/4DGL-uLCD-SE/
int textSize;
float legalLimit;

void resetDisplay(){
    uLCD.background_color(BLACK);
    uLCD.cls();
    uLCD.textbackground_color(BLACK);
    displayStart();    
}

void displayTest(float out, bool isUtahMode){
    legalLimit = (isUtahMode) ? 0.05 : 0.08;
    
    uLCD.baudrate(115200);
    uLCD.background_color(WHITE);
    uLCD.cls();
    uLCD.textbackground_color(WHITE);
    
    textSize = 1;
    uLCD.locate(0, 1);  
    uLCD.text_width(textSize);   
    uLCD.text_height(textSize);      
    uLCD.color(BLACK);     
    uLCD.printf("Your BAC is:%.2f", out);

    uLCD.locate(0, 3);     
    uLCD.printf("The maximum legal limit is %.2f", legalLimit);
    
    uLCD.locate(0, 6);
    if (out < legalLimit){
        uLCD.color(BLUE); 
        uLCD.printf("You are under the legal limit.", legalLimit);
    }
    else{
        uLCD.color(RED); 
        uLCD.printf("You are drunk! \nDo not Drive!");
    }
}

void displayStart(){
    textSize = 1;
    uLCD.locate(3, 1); 
    uLCD.text_width(textSize);    
    uLCD.text_height(textSize);      
    uLCD.color(RED);
    uLCD.printf("Breathalyzer \n");
    
    uLCD.locate(0, 3);     
    uLCD.text_width(textSize);     
    uLCD.text_height(textSize);   
    uLCD.color(BLUE);  
    uLCD.printf("Press button to \nconduct test\n");
}

void displayOut(float out, bool isUtahMode){
    if(out == -1.0){
        displayStart();
    }
    else{
        displayTest(out, isUtahMode);
    }
}