//Written by Todd Clark
#include "convertToBAC.h"

float getBAC(float input){
    float voltage = input * 3; //Conversion from input resistance to voltage.
    float calibratedVoltage = voltage / 0.6; //Convert voltage to work with our 3 volt output signal.
    float ppm = 1033.992 + (55.84479 - 1033.992)/(1 + pow((calibratedVoltage/4.540421), 8.423297)); //Calculate ppm from our voltage values based on specs for MQ-3 gas sensor.
    float bac = (ppm * 0.21) / 100; //Calculate BAC from ppm. Formula taken from http://nootropicdesign.com/projectlab/2010/09/17/arduino-breathalyzer/
    float calibratedBac = bac - 0.12; //Calibrate sensor based on value at 0% alcohol.
    return (calibratedBac < 0.0) ? 0 : calibratedBac;
}