#include "mbed.h"
#include "PinDetect.h"

// D9 is dead lol
PinDetect  L_p_pin( D8  );
PinDetect  L_r_pin( D10 );
PinDetect  L_m_pin( D11 );
PinDetect  L_i_pin( D12 );
PinDetect  L_t_pin( D13 );
PinDetect  R_p_pin( D3  );
PinDetect  R_r_pin( D4  );
PinDetect  R_m_pin( D5  );
PinDetect  R_i_pin( D6  );
PinDetect  R_t_pin( D7  );
DigitalOut led1( LED1 );
Serial mac( USBTX, USBRX );

void L_p_Pressed( void ) { mac.printf("5\r\n"); }
void L_r_Pressed( void ) { mac.printf("4\r\n"); }
void L_m_Pressed( void ) { mac.printf("3\r\n"); }
void L_i_Pressed( void ) { mac.printf("2\r\n"); }
void L_t_Pressed( void ) { mac.printf("1\r\n"); }

void L_p_Released( void ) { mac.printf("5u\r\n"); }
void L_r_Released( void ) { mac.printf("4u\r\n"); }
void L_m_Released( void ) { mac.printf("3u\r\n"); }
void L_i_Released( void ) { mac.printf("2u\r\n"); }
void L_t_Released( void ) { mac.printf("1u\r\n"); }

void R_p_Pressed( void ) { mac.printf("10\r\n"); }
void R_r_Pressed( void ) { mac.printf("9\r\n"); }
void R_m_Pressed( void ) { mac.printf("8\r\n"); }
void R_i_Pressed( void ) { mac.printf("7\r\n"); }
void R_t_Pressed( void ) { mac.printf("6\r\n"); }

void R_p_Released( void ) { mac.printf("10u\r\n"); }
void R_r_Released( void ) { mac.printf("9u\r\n"); }
void R_m_Released( void ) { mac.printf("8u\r\n"); }
void R_i_Released( void ) { mac.printf("7u\r\n"); }
void R_t_Released( void ) { mac.printf("6u\r\n"); }

void keyReleased( void )
{
    led1 = 0;
}

void keyPressedHeld( void )
{

}

void keyReleasedHeld( void )
{

}

int main()
{
    L_p_pin.mode( PullUp );
    L_r_pin.mode( PullUp );
    L_m_pin.mode( PullUp );
    L_i_pin.mode( PullUp );
    L_t_pin.mode( PullUp );
    L_p_pin.attach_asserted( &L_p_Pressed );
    L_r_pin.attach_asserted( &L_r_Pressed );
    L_m_pin.attach_asserted( &L_m_Pressed );
    L_i_pin.attach_asserted( &L_i_Pressed );
    L_t_pin.attach_asserted( &L_t_Pressed );
    L_p_pin.attach_deasserted( &L_p_Released );
    L_r_pin.attach_deasserted( &L_r_Released );
    L_m_pin.attach_deasserted( &L_m_Released );
    L_i_pin.attach_deasserted( &L_i_Released );
    L_t_pin.attach_deasserted( &L_t_Released );
    R_p_pin.mode( PullUp );
    R_r_pin.mode( PullUp );
    R_m_pin.mode( PullUp );
    R_i_pin.mode( PullUp );
    R_t_pin.mode( PullUp );
    R_p_pin.attach_asserted( &R_p_Pressed );
    R_r_pin.attach_asserted( &R_r_Pressed );
    R_m_pin.attach_asserted( &R_m_Pressed );
    R_i_pin.attach_asserted( &R_i_Pressed );
    R_t_pin.attach_asserted( &R_t_Pressed );
    R_p_pin.attach_deasserted( &R_p_Released );
    R_r_pin.attach_deasserted( &R_r_Released );
    R_m_pin.attach_deasserted( &R_m_Released );
    R_i_pin.attach_deasserted( &R_i_Released );
    R_t_pin.attach_deasserted( &R_t_Released );
    
    //pin.attach_asserted_held( &keyPressedHeld );
    //pin.attach_deasserted_held( &keyReleasedHeld );

    L_p_pin.setSampleFrequency(); // Defaults to 20ms.
    L_r_pin.setSampleFrequency();
    L_m_pin.setSampleFrequency();
    L_i_pin.setSampleFrequency();
    L_t_pin.setSampleFrequency();
    R_p_pin.setSampleFrequency();
    R_r_pin.setSampleFrequency();
    R_m_pin.setSampleFrequency();
    R_i_pin.setSampleFrequency();
    R_t_pin.setSampleFrequency();

    while( 1 ) {
        led1 = !led1;
        wait( 0.2 );
    }
}