/**********************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
//#include "max32630fthr.h"
#include "max32630hsp.h"
#include "MAX8614X.h"
#include "USBSerial.h"
void executeSha256(MAX8614X &m, uint8_t *challenge, unsigned int challengeLen, bool romID, uint32_t *response);
bool isTheChipAuthenicated(uint32_t *expectedResponse, uint32_t *chipResponse);

#define RESPONSE_LEN32 8

MAX32630HSP icarus(MAX32630HSP::VIO_1V8);
//    MAX32630FTHR mbed_board(MAX32630FTHR::VIO_1V8);
SPI spi(P5_1, P5_2, P5_0); /* mosi, miso, sclk */
//DigitalOut cs(P3_0);
DigitalOut cs(P5_3);
//PinName interrupt_pin = P3_3;
//PinnName interrupt_pin = P5_7;
//PinName interrupt_pin = P5_5;
//PinName interrupt_pin = P3_6;
//PinName interrupt_pin = P3_7;
//PinName interrupt_pin = P3_2;
PinName interrupt_pin = P5_4;
// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
int main()
{
    #define CHALLENGE_SZ_NO_SECRET 20
    uint8_t challenge_A[CHALLENGE_SZ_NO_SECRET] = {  // 160 bit, no ROM
        0x00, 0x00, 0x00, 0x01,
        0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00
    };
    uint8_t challenge_1[CHALLENGE_SZ_NO_SECRET] = {  // 160 bit
        0x5e, 0x81, 0x35, 0x24,
        0x56, 0x63, 0xd6, 0x09,
        0x99, 0x8d, 0x7b, 0x0d,
        0x52, 0x12, 0x84, 0x65,
        0xcd, 0x0d, 0xe3, 0x01
    };

    uint8_t challenge_2[CHALLENGE_SZ_NO_SECRET] = {  // 160 bit, no ROM
        0xd2, 0xaa, 0x84, 0xc5,
        0x72, 0x77, 0xf7, 0xe5,
        0xdb, 0x8f, 0xd6, 0x12,
        0x96, 0xce, 0x69, 0xf2,
        0x4e, 0xc5, 0x7a, 0xe8
    };

    uint8_t challenge_3[CHALLENGE_SZ_NO_SECRET] = {  // 160 bit, no ROM
        0x21, 0x20, 0x22, 0x80,
        0xcc, 0x9d, 0x45, 0xaa,
        0xb8, 0x13, 0x3e, 0x96,
        0xd6, 0x53, 0x38, 0x0d,
        0x2a, 0xd5, 0xdd, 0x6b
    };
    uint8_t challenge_4[CHALLENGE_SZ_NO_SECRET] = {  // 160 bit, no ROM
        0x4c, 0x3c, 0x0a, 0xca,
        0x61, 0x8a, 0xbd, 0xf2,
        0x34, 0xd8, 0xb3, 0x41,
        0x12, 0x89, 0xf3, 0x78,
        0x65, 0xb6, 0x0d, 0xeb
    };
    uint32_t expectedResponse_1_romID[RESPONSE_LEN32] = {  // 160 bit, no ROM
        0xfe3f805f,
        0x0af066bc,
        0xda0f55e2,
        0x0020ac16,
        0x13fa3406,
        0x59d0e5ae,
        0x79def309,
        0x685981a3
    };
    uint32_t chip_response[RESPONSE_LEN32];
    bool valid = 0;

    #define MAC_SZ 32


//    daplink.printf("daplink serial port\r\n");
//    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_ON;
    gLED = LED_ON;
    bLED = LED_OFF;

    rLED = LED_OFF;
    printf("\r\n\rmax86140 authenication software\r\n");
    MAX8614X m(spi,cs,interrupt_pin);
    //    MAX8614X m(spi,cs,interrupt_pin);
//    m.readRegister(MAX8614X::MAX8614X_PART_ID_REG, data, 1);
//    printf("device id should be 0x24, reg %02X = %02X\r\n", MAX8614X::MAX8614X_PART_ID_REG, data[0]);

//    executeSha256(m, challenge_A, CHALLENGE_SZ_NO_SECRET, 1);
    executeSha256(m, challenge_1, CHALLENGE_SZ_NO_SECRET, 1, chip_response);
    valid = isTheChipAuthenicated(chip_response, expectedResponse_1_romID);
    if (valid)
        printf("\r\n             Challenge 1 passed\r\n\r\n");
    else
        printf("\r\n             Challenge 1 failed\r\n\r\n");
//    executeSha256(m, challenge_2, CHALLENGE_SZ_NO_SECRET, 0);
//    executeSha256(m, challenge_3, CHALLENGE_SZ_NO_SECRET, 1);
//    executeSha256(m, challenge_4, CHALLENGE_SZ_NO_SECRET, 0);
    //- Compare MAC from MAX86140 wth Host's precalculated MAC.
    //- Check PASS or FAIL.
    //- Disable SHA_EN bit ( Write 0 to SHA_EN bit).     
    while(1) {
        gLED = !gLED;
        wait(1.0);
    }
}

bool isTheChipAuthenicated(uint32_t *expectedResponse, uint32_t * chipResponse)
{
    int i;
    for (i = 0; i < RESPONSE_LEN32; i++) {
        if (expectedResponse[i] != chipResponse[i])
            return 0;
    }
    return 1;
}

#if 0
void transformData(uint8_t *inData, uint8_t *outData, unsigned int challengeLen)
{
    int i, j, k;
    k = 0;
    for (i = 0; i < (challengeLen/4); i++) {
        for (j = 3; j >= 0; j--) {
            outData[j+(i*4)] = inData[k];
            k++;
        }
    }
}
#endif
void transformData(uint8_t *inData, uint8_t *outData, unsigned int challengeLen)
{
    int i, j, k;
    k = 0;
    for (i = 0; i < (challengeLen/4); i++) {
        for (j = 3; j >= 0; j--) {
            outData[j+(i*4)] = inData[k];
//            printf("%02X ",inData[k]);
            k++;
        }
//            printf("\r\n");
    }
    for (i=0; i < challengeLen; i++) {
//        if (!(i % 4))
//            printf("\r\n ");
//        printf("%02X ",outData[i]);
    }
}


void executeSha256(MAX8614X &m, uint8_t *challenge, unsigned int challengeLen, bool romID, uint32_t *response)
{
    int i, j, k;
    uint8_t macData[256];
    uint8_t inData[256];
    uint8_t xData[256];
    uint32_t x32Data[64];
    uint32_t tmpData;
    const unsigned int responseLen32 = 8;
    uint8_t data[5];

    //- Enable SHA_DONE Interrupt
    m.writeRegister(MAX8614X::MAX8614X_INT_ENABLE2_REG, MAX8614X::MAX8614X_IE_SHA_DONE_EN);

    m.writeRegister(MAX8614X::MAX8614X_INT_ENABLE1_REG, 0);  // Disable all other interrupts

    //- Enable SHA_EN bit.
    m.writeRegister(MAX8614X::MAX8614X_SHA_CFG_REG,MAX8614X::MAX8614X_SHACFG_SHA_EN);

    //- Write 160-bit random challenge value to RAM using registers MEM_IDX and MEM_DATA.
    // Enable Memory Write, Select Bank 0, address 0x00 to 0xFF
    m.writeRegister(MAX8614X::MAX8614X_MEMORY_CONTROL_REG, MAX8614X::MAX8614X_MEMCNTRL_WR_EN_MASK | MAX8614X::MAX8614X_MEMCNTRL_BANK0_MASK);

    printf("\r\n Raw Input Data\r\n\r\n");
    for (i = 0; i < challengeLen; i++) {
        if (!(i % 4))
            printf("\r\n ");
        printf("%02x", challenge[i]);
    }
    printf("\r\n");
#if 0
    k = 0;
    for (i = 0; i < (challengeLen/4); i++) {
    for (j = 3; j >= 0; j--) {
        
        inData[j+(i*4)] = challenge[k];
        k++;
    }
    }
#endif

    transformData(challenge, xData, challengeLen);

    printf("\r\n Transformed Input Data\r\n\r\n");
    for (i = 0; i < challengeLen; i++) {
        if (!(i % 4))
            printf("\r\n ");
        printf("%02x", xData[i]);
    }
        printf("\r\n ");
        printf("\r\n ");
        
    for (i = 0; i < (challengeLen); i++) {
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_INDEX_REG, i);
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_DATA_REG, xData[i]);
    //}
  }
    printf("%\r\n");
    // The message block consists of a 160-bit secret, a 160-bit challenge and 192 bits of constant data. Optionally, the 64-bit
    // ROM ID replaces 64 of the 192 bits of constant data used in the hash operation. 16 bits out of the 160-bit secret and 16
    // bits of ROM ID are programmable–8 bits each in metal and 8 bits each in OTP bits
    //- Write command, with ROM ID (0x35) or without ROM ID (0x36), to SHA_CMD register
   if (romID) {
        printf("ROMID \r\n");
//        m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG, MAX8614X::MAX8614X_SHACMD_MAC_ROM_ID);
        m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG, MAX8614X::MAX8614X_SHACMD_MAC_ROM_ID);
        wait(1);
}
    else
{
         printf("no ROMID \r\n");
//       m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG,MAX8614X::MAX8614X_SHACMD_MAC_NO_ROM_ID);
       m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG,MAX8614X::MAX8614X_SHACMD_MAC_NO_ROM_ID);
        wait(1);
}


//    m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG,MAX8614X::MAX8614X_SHACMD_MAC_ROM_ID);
//    m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG,MAX8614X::MAX8614X_SHACMD_MAC_NO_ROM_ID);


    m.readRegister(MAX8614X::MAX8614X_SHA_CMD_REG, data, 1);
///    printf("sha cmd reg should be 0x35 mac rom id,  reg %02X = %02X\r\n", MAX8614X::MAX8614X_SHA_CMD_REG, data[0]);
        m.readRegister(MAX8614X::MAX8614X_INT_STATUS2_REG, data, 1);
///        printf("int status2, reg %02X = %X\r\n", MAX8614X::MAX8614X_INT_STATUS2_REG, data[0]);
    //● Write 1 to SHA_START and 1 to SHA_EN bit.
    m.writeRegister(MAX8614X::MAX8614X_SHA_CFG_REG,MAX8614X::MAX8614X_SHACFG_SHA_EN | MAX8614X::MAX8614X_SHACFG_SHA_START);
    m.readRegister(MAX8614X::MAX8614X_SHA_CFG_REG, data, 1);
///    printf("sha CFG reg should be 0x3,  reg %02X = %02X\r\n", MAX8614X::MAX8614X_SHA_CFG_REG, data[0]);
    
    //● Wait for SHA_DONE interrupt.
    m.clearShaComplete();
    data[0] = 0;
//  while(!m.isShaComplete()) {
    while(!m.isShaComplete() && !data[0] ) {
        m.readRegister(MAX8614X::MAX8614X_INT_STATUS2_REG, data, 1);
        printf("int status2, reg %02X = %X\r\n", MAX8614X::MAX8614X_INT_STATUS2_REG, data[0]);
        
    }
    // ● Read 256 MAC value from RAM using registers MEM_IDX and MEM_DATA.
    printf("\r\n Raw Output\r\n\r\n");
    for (i = 64; i < 64+32; i++) {
        if (!(i % 4))
            printf("\r\n ");
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_INDEX_REG, i);
        m.readRegister(MAX8614X::MAX8614X_MEMORY_DATA_REG, data, 1);
        xData[i-64] = data[0];
        printf("%02x", data[0]);
    } 
    printf("%\r\n");

    transformData(xData,macData, 32);
#if 0
    printf("\r\n Formatted Response\r\n\r\n");
    for (i = 0; i < 32; i++) {
        if (!(i % 4))
            printf("\r\n ");
        printf("%02x", macData[i]);
    }
    printf("\r\n\r\n");
    
#endif
     // transform data to Little-Endian
    k = 0;
    for (i = 0; i < (responseLen32); i++) {
        tmpData = challenge[i];
        x32Data[i] = 0;
        for (j = 3; j >= 0; j--) {
            x32Data[i] = x32Data[i] << 8;
            x32Data[i] |= macData[k] & 0xFF;
            k++;
        }
        
    }

    printf("\r\n Formatted Response\r\n\r\n");
    for (i = 0; i < responseLen32; i++) {
        printf(" %08X \r\n",x32Data[i]);
        response[i] = x32Data[i];
    }

     
}