/**********************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
//#include "max32630fthr.h"
#include "max32630hsp.h"
#include "MAX8614X.h"
#include "USBSerial.h"

MAX32630HSP icarus(MAX32630HSP::VIO_1V8);
//    MAX32630FTHR mbed_board(MAX32630FTHR::VIO_1V8);
SPI spi(P5_1, P5_2, P5_0); /* mosi, miso, sclk */
DigitalOut cs(P3_0);
PinName interrupt_pin = P5_4;
// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
int main()
{
    uint8_t data[1];
    int c;

//    daplink.printf("daplink serial port\r\n");
//    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_ON;
    gLED = LED_ON;
    bLED = LED_OFF;

    rLED = LED_OFF;
    
    printf("\r\n\rmax86140 authenication software\r\n");
    MAX8614X m(spi,cs,interrupt_pin);
    m.readRegister(0xff, data, 1);
    printf("device id should be 0x24, read val = %x\r\n", data[0]);
    
    while(1) {
//        c = microUSB.getc();
//        microUSB.putc(c);
 //       daplink.putc(c);
        gLED = !gLED;
        wait(1.0);
    }
}

