/**********************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
//#include "max32630fthr.h"
#include "max32630hsp.h"
#include "MAX8614X.h"
#include "USBSerial.h"

MAX32630HSP icarus(MAX32630HSP::VIO_1V8);
//    MAX32630FTHR mbed_board(MAX32630FTHR::VIO_1V8);
SPI spi(P5_1, P5_2, P5_0); /* mosi, miso, sclk */
//DigitalOut cs(P3_0);
DigitalOut cs(P5_3);
//PinName interrupt_pin = P3_3;
//PinnName interrupt_pin = P5_7;
//PinName interrupt_pin = P5_5;
//PinName interrupt_pin = P3_6;
//PinName interrupt_pin = P3_7;
//PinName interrupt_pin = P3_2;
PinName interrupt_pin = P5_4;
// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
int main()
{
    #define CHALLENGE_SZ 20
    static const uint8_t challenge_1[CHALLENGE_SZ] = {  // 160 bit
        0x5e, 0x81, 0x35, 0x24,
        0x56, 0x63, 0xd6, 0x09,
        0x99, 0x8d, 0x7b, 0x0d,
        0x52, 0x12, 0x84, 0x65,
        0xcd, 0x0d, 0xe3, 0x01
    };

    #define MAC_SZ 32
    uint8_t macData[MAC_SZ];
    uint8_t data[5];
    int i;

//    daplink.printf("daplink serial port\r\n");
//    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_ON;
    gLED = LED_ON;
    bLED = LED_OFF;

    rLED = LED_OFF;
    printf("\r\n\rmax86140 authenication software\r\n");
    MAX8614X m(spi,cs,interrupt_pin);
    m.readRegister(MAX8614X::MAX8614X_PART_ID_REG, data, 1);
    printf("device id should be 0x24, reg %02X = %02X\r\n", MAX8614X::MAX8614X_PART_ID_REG, data[0]);

    //● Enable SHA_DONE Interrupt
    m.writeRegister(MAX8614X::MAX8614X_INT_ENABLE2_REG, MAX8614X::MAX8614X_IE_SHA_DONE_EN);

    m.readRegister(MAX8614X::MAX8614X_INT_ENABLE2_REG, data, 1);
    printf("enable sha done interrupt, reg %02X = %02X\r\n", MAX8614X::MAX8614X_INT_ENABLE2_REG, data[0]);


    //● Enable SHA_EN bit.
    m.writeRegister(MAX8614X::MAX8614X_SHA_CFG_REG,MAX8614X::MAX8614X_SHACFG_SHA_EN);

    m.readRegister(MAX8614X::MAX8614X_SHA_CFG_REG, data, 1);
    printf("enable sha CFG,  reg %02X = %02X\r\n", MAX8614X::MAX8614X_SHA_CFG_REG, data[0]);
    
    //● Write 160-bit random challenge value to RAM using registers MEM_IDX and MEM_DATA.
    // Enable Memory Write, Select Bank 0, address 0x00 to 0xFF
    m.writeRegister(MAX8614X::MAX8614X_MEMORY_CONTROL_REG, MAX8614X::MAX8614X_MEMCNTRL_WR_EN_MASK | MAX8614X::MAX8614X_MEMCNTRL_BANK0_MASK);
       m.readRegister(MAX8614X::MAX8614X_MEMORY_CONTROL_REG, data, 1);
    printf("MEM CNTRL REG should be 2,  reg %02X = = %02X\r\n", MAX8614X::MAX8614X_MEMORY_CONTROL_REG, data[0]);
 
    for (i = 0; i < CHALLENGE_SZ; i++) {
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_INDEX_REG, i);
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_DATA_REG, challenge_1[i]);
    } 

    for (i = 0; i < CHALLENGE_SZ; i++) {
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_INDEX_REG, i);
        m.readRegister(MAX8614X::MAX8614X_MEMORY_DATA_REG, data, 1);
        printf("%02x ", data[0]);
    } 
    printf("%\r\n");
    // The message block consists of a 160-bit secret, a 160-bit challenge and 192 bits of constant data. Optionally, the 64-bit
    // ROM ID replaces 64 of the 192 bits of constant data used in the hash operation. 16 bits out of the 160-bit secret and 16
    // bits of ROM ID are programmable–8 bits each in metal and 8 bits each in OTP bits
    //● Write command, with ROM ID (0x35) or without ROM ID (0x36), to SHA_CMD register
    m.writeRegister(MAX8614X::MAX8614X_SHA_CMD_REG,MAX8614X::MAX8614X_SHACMD_MAC_ROM_ID);

    m.readRegister(MAX8614X::MAX8614X_SHA_CMD_REG, data, 1);
    printf("sha cmd reg should be 0x35 mac rom id,  reg %02X = %02X\r\n", MAX8614X::MAX8614X_SHA_CMD_REG, data[0]);
        m.readRegister(MAX8614X::MAX8614X_INT_STATUS2_REG, data, 1);
        printf("int status2, reg %02X = %X\r\n", MAX8614X::MAX8614X_INT_STATUS2_REG, data[0]);
    //● Write 1 to SHA_START and 1 to SHA_EN bit.
    m.writeRegister(MAX8614X::MAX8614X_SHA_CFG_REG,MAX8614X::MAX8614X_SHACFG_SHA_EN | MAX8614X::MAX8614X_SHACFG_SHA_START);
    m.readRegister(MAX8614X::MAX8614X_SHA_CFG_REG, data, 1);
    printf("sha CFG reg should be 0x3,  reg %02X = %02X\r\n", MAX8614X::MAX8614X_SHA_CFG_REG, data[0]);
    
    //● Wait for SHA_DONE interrupt.
    m.clearShaComplete();
    data[0] = 0;
//  while(!m.isShaComplete()) {
    while(!m.isShaComplete() && !data[0] ) {
        m.readRegister(MAX8614X::MAX8614X_INT_STATUS2_REG, data, 1);
        printf("int status2, reg %02X = %X\r\n", MAX8614X::MAX8614X_INT_STATUS2_REG, data[0]);
        
    }   
    // ● Read 256 MAC value from RAM using registers MEM_IDX and MEM_DATA.
    for (i = 0; i < MAC_SZ; i++) {
        m.writeRegister(MAX8614X::MAX8614X_MEMORY_INDEX_REG, i);
        m.readRegister(MAX8614X::MAX8614X_MEMORY_DATA_REG, data, 1);
        macData[i] = data[0];
        printf("%02x ", data[0]);
    } 
     printf("%\r\n");
   //● Compare MAC from MAX86140 wth Host's precalculated MAC.
    //● Check PASS or FAIL.
    //● Disable SHA_EN bit ( Write 0 to SHA_EN bit).     
    while(1) {
        gLED = !gLED;
        wait(1.0);
    }
}

