#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

/* Analog inputs 0 and 1 have internal dividers to allow measuring 5V signals  
 * The dividers are selected by using inputs AIN_4 and AIN_5 respectively.
 * The full scale range for AIN0-3 is 1.2V
 * The full scale range for AIN4-5 is 6.0V
 */
AnalogIn ain1(AIN_5);
const float AIN5_FSV = 6.0f;   /* Full scale value for AIN5 */

float celsius_to_fahrenheit(float temp_c)
{
    float temp_f;
    temp_f = ((temp_c * 9)/5) + 32;
    return temp_f;
}

void blink_timer(void) {
        gLED = !gLED;  /* blink the green LED */
}


// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for MAX6605
* @version 1.0000.0000
*
* @details Sample main program for MAX6605
* The MAX6605 precision, low-power, analog output temperature 
* sensor is available in a 5-pin SC70 (0.65 mm pitch)package.
* The device has a +2.7V to +5.5V supply voltage range
* and 10µA supply current over the -55°C to +125°C temperature range.
* For the -40°C to +105°C temperature range, the supply voltage can go as low as +2.4V.
* Supply Current: 10µA
* Supply voltage: 2.7V to 5.5V
* Accuracy : ±0.75°C 25°C
*            ±3.00°C 0.0°C to 70°C
*            ±3.80°C -20°C to 85°C
*            ±5.00°C -40°C to 100°C
*            ±5.80°C -55°C to 125°C
*
* The prints are sent to the terminal window (9600, 8n1).
* The program sets the GPIOs to 3.3V and the program
* configures the chip and reads temperatures.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
    float temperature;
    uint32_t i;
    const float A = 0.000001604f;
    const float B = 0.0119f;
    const float C1 = 0.744f;
    float c2;
    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_OFF;
    gLED = LED_OFF;
    bLED = LED_OFF;
    Ticker ticker;   // calls a callback repeatedly with a timeout
    ticker.attach(callback(&blink_timer), 1.0f);  /* set timer for one second */

    daplink.printf("MAX6605 Temperature Sensor\r\n\r\n");

    temperature = (float)(((AIN5_FSV * ain1) -0.744f) / 0.0119f);
#if 0
    daplink.printf("AIN1: %1.5f\n", (AIN5_FSV * ain1) );  // analog inputs 1
#endif

    daplink.printf("Temperature using Linear Approximation\r\n");
    for (i = 0; i < 8; i++) {
        temperature = (float)(((AIN5_FSV * ain1) -0.744f) / 0.0119f);
        daplink.printf("temperature: %3.1f degrees C, %3.1f degrees F\r\n", temperature, celsius_to_fahrenheit(temperature));
        wait(2);
    }
    daplink.printf("\r\n");

    daplink.printf("Temperature using the Quadratic Equation\r\n");
    for (i = 0; i < 8; i++) {
        c2 = AIN5_FSV * ain1;
        temperature = (-B + sqrt(B*B - 4*A*(C1-c2)))/(2*A);
        daplink.printf("temperature: %3.1f degrees C C, %3.1f degrees F\r\n", temperature, celsius_to_fahrenheit(temperature));
        wait(2);
    }
    daplink.printf("\r\n\r\n");

    while(1) {
    }
}

