/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "MAX30101.h"
#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_1V8);  // Change the GPIOs from 3.3V to 1.8V

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
#define MAX30101_I2C_SLAVE_ADDR (0xAE)
MAX30101 HrSensor(P3_4, P3_5, MAX30101_I2C_SLAVE_ADDR);  // SDA, SCL, i2c 7-bit address
    
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for MAX30101
* @version 1.0000.0
*
* @details Sample main program for MAX30101.
* The prints are sent to the terminal window (9600, 8n1).
* The program sets the GPIOs to 1.8V and the program
* blinks green if it's able to communicate with
* the MAX30101, otherwise, it blinks red.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
    char value=0;
    int ret;

    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);

    while (true) {  // Blink the blue-green LED 
        ret = HrSensor.i2c_reg_read(MAX30101::REG_ID,&value);
        if (value == 0x15) {
            printf("MAX30101 Heart Rate Sensor Part ID = %#X\r\n", value);
            rLED = LED_OFF;
            gLED = !gLED;
        }else {
            printf("Error, MAX30101 Part ID %#X is not correct, ret = %d\r\n", value, ret);
            gLED = LED_OFF;
            rLED = !rLED;
        }
        printf("\r\n");
        wait(1.0);
    }
}

