/*******************************************************************************
* Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "ds7505.h"
#include "ds7505_cpp.h"
#include "USBSerial.h"

Serial pc(USBTX, USBRX);          // Use USB debug probe for serial link
Serial uart(P2_1, P2_0);
void wait_sec_prompt(uint8_t time)
{
   // Ports and serial connections
    uint32_t i;
    for (i = 0; i < time; i++) {
        pc.printf(".");
        wait(1);
    }
    pc.printf("\r\n");
}


MAX32630FTHR pegasus(MAX32630FTHR::VIO_1V8); 
 
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
 
I2C i2cBus(P3_4, P3_5);

void blink_timer(void) {
        gLED = !gLED;  /* blink the green LED */
}

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for DS7505
* @version 1.0000.0000
*
* @details Sample main program for DS7505
* The prints are sent to the terminal window (9600, 8n1).
* The program sets the GPIOs to 1.8V and the program
* configures the chip and reads temperatures.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
#define WAIT_TIME 8
    uint32_t i;
    float temperature;
    uint8_t cfg;
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    gLED = LED_ON;
    Ticker ticker;   // calls a callback repeatedly with a timeout
    ticker.attach(callback(&blink_timer), 0.5f);  /* set timer for 0.5 second */
    pc.baud(9600);                    // Baud rate = 115200
    pc.printf("DS7505 Digital Thermometer and "
        "Thermostat example source code.\r\n");
    pc.printf("\r\n");
    uint8_t i2c_addr = DS7505_I2C_SLAVE_ADR_00;
    DS7505 temp_sensor(i2cBus, i2c_addr);
    i2cBus.frequency(400000);
    /* Configure for 9 bit, fault filter 6,
       active low polarity, comparator mode, continuous
     */
    temp_sensor.write_cfg_reg(uint8_t(
        DS7505_CFG_RESOLUTION_9BIT | DS7505_CFG_FAULT_FILTER_6 |
        DS7505_CFG_OS_POLARITY_ACT_LOW | DS7505_CFG_COMPARATOR_MODE |
        DS7505_CFG_CONTINUOUS));
    for (i = 0; i < 10; i++) {
        wait(DS7505_WAIT_CONV_TIME_9BIT);
        temperature =
            temp_sensor.read_reg_as_temperature(DS7505_REG_TEMPERATURE);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    temp_sensor.read_cfg_reg(&cfg);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);
#if 0
    temp_sensor.write_trip_low_thyst(-63.9375);
    temperature =
        temp_sensor.read_reg_as_temperature(DS7505_REG_THYST_LOW_TRIP);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));

    temp_sensor.write_trip_high_tos(64.0625f);
    temperature = temp_sensor.read_reg_as_temperature(DS7505_REG_TOS_HIGH_TRIP);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    pc.printf("\r\n\r\n");
#endif

    pc.printf("\r\n");
    for (i = 0; i < 8; i++) {
        /* Configure to shutdown mode */
        temp_sensor.write_cfg_reg(uint8_t(
            DS7505_CFG_RESOLUTION_12BIT | DS7505_CFG_FAULT_FILTER_4 |
            DS7505_CFG_OS_POLARITY_ACT_LOW | DS7505_CFG_INTERRUPT_MODE |
            DS7505_CFG_SHUTDOWN));
        wait_sec_prompt(WAIT_TIME); /*  leave it in shutdown mode for a while */
        /* Configure for 12 BIT, fault filter 4,
           active low polarity, interrupt mode, continuous
         */
        temp_sensor.write_cfg_reg(uint8_t(
            DS7505_CFG_RESOLUTION_12BIT | DS7505_CFG_FAULT_FILTER_4 |
            DS7505_CFG_OS_POLARITY_ACT_LOW | DS7505_CFG_INTERRUPT_MODE |
            DS7505_CFG_CONTINUOUS));
        wait(DS7505_WAIT_CONV_TIME_12BIT);
        temperature =
            temp_sensor.read_reg_as_temperature(DS7505_REG_TEMPERATURE);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    temp_sensor.read_cfg_reg(&cfg);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);

    pc.printf("\r\n\r\n");

#if 0
    temp_sensor.write_trip_low_thyst(-55.0f);
    temperature = 
        temp_sensor.read_reg_as_temperature(DS7505_REG_THYST_LOW_TRIP);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));

    temp_sensor.write_trip_high_tos(125.0f);
    temperature = temp_sensor.read_reg_as_temperature(DS7505_REG_TOS_HIGH_TRIP);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    pc.printf("\r\n\r\n");
#endif

    /***************************************************************************
     * Call the C code version of the driver
     ***************************************************************************
     */
#include "ds7505_c.h"
    pc.printf("C implementation of the code\r\n");
    ds7505_init(i2c_addr);
    /* Configure for 9 bit, fault filter 6,
       active low polarity, comparator mode, continuous
     */
    ds7505_write_cfg_reg(uint8_t(
        DS7505_CFG_RESOLUTION_9BIT | DS7505_CFG_FAULT_FILTER_6 |
        DS7505_CFG_OS_POLARITY_ACT_LOW | DS7505_CFG_COMPARATOR_MODE |
        DS7505_CFG_CONTINUOUS), i2cBus);
    for (i = 0; i < 10; i++) {
        wait(DS7505_WAIT_CONV_TIME_9BIT);
        temperature = ds7505_read_reg_as_temperature(DS7505_REG_TEMPERATURE,
            i2cBus);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }

    ds7505_read_cfg_reg(&cfg, i2cBus);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);

#if 0
    ds7505_write_trip_low_thyst(-63.9375, i2cBus);
    temperature = ds7505_read_reg_as_temperature(DS7505_REG_THYST_LOW_TRIP,
        i2cBus);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, ds7505_celsius_to_fahrenheit(temperature));

    ds7505_write_trip_high_tos(64.0625f, i2cBus);
    temperature = ds7505_read_reg_as_temperature(DS7505_REG_TOS_HIGH_TRIP,
        i2cBus);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, ds7505_celsius_to_fahrenheit(temperature));
#endif

    pc.printf("\r\n");
    for (i = 0; i < 8; i++) {
        /* Configure for shutdown mode */
        ds7505_write_cfg_reg(uint8_t(
            DS7505_CFG_RESOLUTION_12BIT | DS7505_CFG_FAULT_FILTER_4 |
            DS7505_CFG_OS_POLARITY_ACT_LOW | DS7505_CFG_INTERRUPT_MODE |
            DS7505_CFG_SHUTDOWN), i2cBus);
        wait_sec_prompt(WAIT_TIME); /*  leave it in shutdown mode for a while */
        /* Configure for 12 bits, fault filter 4,
           active low polarity, interrupt mode, continuous
         */
        ds7505_write_cfg_reg(uint8_t(
            DS7505_CFG_RESOLUTION_12BIT | DS7505_CFG_FAULT_FILTER_4 |
            DS7505_CFG_OS_POLARITY_ACT_LOW | DS7505_CFG_INTERRUPT_MODE |
            DS7505_CFG_CONTINUOUS), i2cBus);
        wait(DS7505_WAIT_CONV_TIME_12BIT);
        temperature = ds7505_read_reg_as_temperature(DS7505_REG_TEMPERATURE,
            i2cBus);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    ds7505_read_cfg_reg(&cfg, i2cBus);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);

#if 0
    ds7505_write_trip_low_thyst(-55, i2cBus);
    temperature = ds7505_read_reg_as_temperature(DS7505_REG_THYST_LOW_TRIP,
        i2cBus);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, ds7505_celsius_to_fahrenheit(temperature));

    ds7505_write_trip_high_tos(125.0f, i2cBus);
    temperature = ds7505_read_reg_as_temperature(DS7505_REG_TOS_HIGH_TRIP,
        i2cBus);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, ds7505_celsius_to_fahrenheit(temperature));
#endif
    pc.printf("\r\n\r\n\r\n");


    while (true) { 
    }
}
 
 