/*******************************************************************************
* Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
* @file DS1775.h
*******************************************************************************
*/
#ifndef DS1775_H
#define DS1775_H
#include "mbed.h"

#define DS1775_NO_ERROR   0
#define DS1775_ERROR      -1

#define DS1775_REG_TEMPERATURE      0X00
#define DS1775_REG_CONFIGURATION    0X01
#define DS1775_REG_THYST_LOW_TRIP   0X02 
#define DS1775_REG_TOS_HIGH_TRIP    0X03 
#define DS1775_REG_MAX              0X03

#define WAIT_MARGIN (0.0006)
#define DS1775_WAIT_CONV_TIME_9BIT  (0.1875+WAIT_MARGIN)
#define DS1775_WAIT_CONV_TIME_10BIT (0.375+2*WAIT_MARGIN)
#define DS1775_WAIT_CONV_TIME_11BIT (0.750+4*WAIT_MARGIN)
#define DS1775_WAIT_CONV_TIME_12BIT (1.5+8*WAIT_MARGIN)

#define DS75_WAIT_CONV_TIME_9BIT  (0.12+WAIT_MARGIN)
#define DS75_WAIT_CONV_TIME_10BIT (0.3+2*WAIT_MARGIN)
#define DS75_WAIT_CONV_TIME_11BIT (0.6+4*WAIT_MARGIN)
#define DS75_WAIT_CONV_TIME_12BIT (1.2+8*WAIT_MARGIN)

#define DS1775_CFG_CONTINUOUS       (0X00 << 0)
#define DS1775_CFG_SHUTDOWN         (0X01 << 0)

#define DS1775_CFG_COMPARATOR_MODE  (0X00 << 1)
#define DS1775_CFG_INTERRUPT_MODE   (0X01 << 1)

#define DS1775_CFG_OS_POLARITY_ACT_LOW  (0x00 << 2)
#define DS1775_CFG_OS_POLARITY_ACT_HIGH (0x01 << 2)

#define DS1775_CFG_FAULT_FILTER_1   (0x00 << 3)
#define DS1775_CFG_FAULT_FILTER_2   (0x01 << 3)
#define DS1775_CFG_FAULT_FILTER_4   (0x02 << 3)
#define DS1775_CFG_FAULT_FILTER_6   (0x03 << 3)

#define DS1775_CFG_RESOLUTION_9BIT  (0x00 << 5)
#define DS1775_CFG_RESOLUTION_10BIT (0x01 << 5)
#define DS1775_CFG_RESOLUTION_11BIT (0x02 << 5)
#define DS1775_CFG_RESOLUTION_12BIT (0x03 << 5)






#define DS1775_CFG_OVER_TEMP_MASK   (0x80)


#define DS1775_I2C_SLAVE_ADR_R0 (0x90 >> 1) // code uses the 7 bit address
#define DS1775_I2C_SLAVE_ADR_R1 (0x92 >> 1)
#define DS1775_I2C_SLAVE_ADR_R2 (0x94 >> 1)
#define DS1775_I2C_SLAVE_ADR_R3 (0x96 >> 1)
#define DS1775_I2C_SLAVE_ADR_R4 (0x98 >> 1)
#define DS1775_I2C_SLAVE_ADR_R5 (0x9A >> 1)
#define DS1775_I2C_SLAVE_ADR_R6 (0x9C >> 1)
#define DS1775_I2C_SLAVE_ADR_R7 (0x9E >> 1)

#define DS1775_CF_LSB           (0.00390625F)

/** @union ds1775_raw_data
 * @brief union data structure for byte word manipulations
 */
union ds1775_raw_data {
    struct {
        uint8_t lsb;
        uint8_t msb;
    };
    struct {
        uint16_t magnitude_bits:15;
        uint16_t sign_bit:1;
    };
    uint16_t uwrd;
    int16_t swrd;
};
#define DS1775_U16_MAX     ((uint16_t)~0U)
#define DS1775_S16_MAX     ((int16_t)(DS1775_U16_MAX>>1))
#define DS1775_S16_MIN     ((int16_t)(-DS1775_S16_MAX - 1))

#endif/* MAX31875_H */