// example for Source Code Pro 31px font
 
#include "stdio.h"
#include "mbed.h"
#include "string"
#include "SourceCodePro31.h"
#include "SPI_TFT.h"

// the TFT is connected to SPI pin 11-13
SPI_TFT TFT(p11, p12, p13, p14, p15,"TFT"); // mosi, miso, sclk, cs, reset

int main() {
    int i, j; float f;
    TFT.claim(stdout);      // send stdout to the TFT display 

    TFT.set_orientation(1);

  for(j = 0; 1; j++) {
    TFT.background(Blue);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen

    TFT.set_orientation(1);
    TFT.set_font((unsigned char*) SCProSB31x55);
      
    for(i = 0; i < 320; i++) {
      f = rand() / 1E9 - 1;
      f = f / 5 + sin(i / 26.0);
      TFT.locate(0,10);
      TFT.printf("%c", f < 0 ? '-' : '+');
      TFT.locate(33,10);
      TFT.printf("%7.5f", abs(f));
      TFT.locate(250,10);
//      TFT.printf("}\x7f");
      TFT.printf("}A");
      TFT.line(i,150,i,150-f*50, f > 0 ? White : Red);
      wait_ms(j & 1 ? 80 : 300
      ); 
      } 
    }
  }

