#include "mbed.h"
#include "SDFileSystem.h"
#include <stdint.h>


Serial pc(USBTX, USBRX);
InterruptIn R_Button(SW1);
AnalogIn measure(PTB0);
SDFileSystem sd(PTD6, PTD7, PTD5, PTD4, "sd");
Ticker t;
float buffer;
bool flag = 0;

void active() {
    FILE *samples = fopen("/sd/samples.csv", "a"); 
    buffer = measure.read();
    if(buffer!=0) {
        fprintf(samples, "%f\n", buffer);
        pc.printf("Reading %f\n", buffer);
        buffer = 0;
    }
    fclose(samples);
}

void change() {
    pc.printf("In change function\n");
    if (flag == 0) {
        printf("Enabling Oscilloscope\n");
        t.attach(&active, .01);
        flag = 1;
        printf("Flag set to 1\n");
    }
    else {
        printf("Disabling Oscilloscope\n");
        t.detach();
        flag = 0;
        printf("Flag set to 0\n");
    }
}

int main() {
    pc.baud(115200);
    pc.printf("Connection Established\n");
    pc.printf("File should be created\n");
    FILE *samples = fopen("/sd/samples.csv", "w");
    if(samples == NULL) {
         pc.printf("But the file doesn't exist \n");
    }
    
    fclose(samples);
    R_Button.mode(PullUp);
    R_Button.fall(&change);
    while(true) {
    }
}