#include "mbed.h"

PwmOut motorc(PTB19);
DigitalOut dir1(PTC11);
DigitalOut dir2(PTC10);

Serial pc(USBTX, USBRX);
float duty[8] = {1, 0.75, 0.5, 0.25, 0.25, 0.5, 0.75, 1};
int index = 0;
char entry;

int main()
{
    pc.baud(115200);
    pc.printf("Connection Established\n");
    while (true) {
        entry = 'A';
        while (entry != '+' && entry != '-') {
            pc.printf("Enter a key\n");
            pc.scanf("%c", &entry);
            pc.printf("\n%c\n", entry);
            if(entry == '+' && index < 7)
            {
                index=index + 1;
                pc.printf("Increase Speed, current speed %f\n", duty[index]);
            }
            if(entry == '-' && index > 0)
            {
                index=index - 1;
                pc.printf("Decrease Speed, current speed %f\n", duty[index]);
            }
        }
        if(index <=3)
        {
            dir1 = 0;
            dir2 = 1;
        }
        if(index >3)
        {
            dir1 = 1;
            dir2 = 0;
        }
        motorc.write(duty[index]);
    }
}