
#include "mbed.h"
#include "Stepper.h"
#include "FSR.h"
#define pi 3.141592653589793

FSR gauge1(PA_1, 10);      // A1 Strain gauge, a 10k resistor is used
FSR gauge2(PA_4, 10);      // A2 Strain gauge
DigitalIn home(PA_9);      // D8
DigitalIn switch1(PB_3);   // D3 Switch => Rouge
DigitalIn switch2(PB_5);   // D4 Switch => Noir
InterruptIn switch3(PA_10);  // D2 Switch => Vert
Stepper mot(PB_6, PC_7);   // D10 D9 motor :NEMA 17
DigitalOut myled(LED2);
Serial s(SERIAL_TX, SERIAL_RX);


int main()
{
////////////////// Initialisation //////////////////
    float entree          = 0;
    int mode            = 0;       // Pousser (1)  ou tirer (2)
    float vitesse         = 0;       // vitesse d'avance
    float avance          = 0;       // avance, nombre de pas à realiser
    int vol_ou_deb      = 0;       // travailler en volume (1) ou en debit (2)
    float section         = 0;       // section de la seringue
    float volume          = 0;       // volume demande
    float debit           = 0;       // debit demande
    mot.setSpeed(80000);           // vitesse max <!> NE PAS METTRE DE MICROPAS <!>
    int paire=0;
    int change=0;

////////////////// Mode : Pousser ou tirer ? //////////////////
    printf("Bonjour utilisateur, quel mode souhaitez-vous utiliser :\n");
    printf("Pour vider une seringue de son contenu, tapez 1 \n");
    printf("Pour remplir une seringue, tapez 2 \n");
    scanf("%d", &mode);                                            // Choix du mode
    while( mode != 1 && mode != 2) 
    {                   // Verifie que l'entree est correcte
        printf("Une erreur s'est produite quelque part.\n");
        printf("Pour vider une seringue de son contenu, tapez 1 \n");
        printf("Pour remplir une seringue, tapez 2 \n");
        scanf("%d", &mode);
    }

//////////////////  Si pousser : placement du chariot //////////////////
    if (mode == 1)                              // On retourne vers le moteur puis on avance jusqu'à toucher la seringue
    {                            
        mot.rotate(0);                          // Sens de rotation : 1 = pousser, 0 = tirer
        while (switch2 == 0 && switch3 == 0)    // Tant que pas à fond à gauche (côte moteur) ou switch3 pas enfonce, on continue
        {
        }
        mot.stop();
        printf("Veuillez placez la seringue. \n Une fois la seringue mise en place, tapez 1\n");
        scanf("%f", &entree);
        while( entree != 1) {                   // Verifie que l'entree est correcte
            printf("L'entree est incorrecte.\n");
            printf("Une fois la seringue mise en place, tapez 1\n");
            scanf("%f", &entree);
        }
        mot.rotate(1);                          // Puis on repart dans l'autre sens.
        while(gauge1.readRaw() <= 0.4 && switch1 == 0)          //Tant que le contacte n'a pas eu lieu
        {
        }
        mot.stop();
        printf("Le contact entre la seringue et la fixation est realise\n");
    }

//////////////////  Si tirer : placement du chariot //////////////////
    if (mode == 2)                              // Si tirer
    {                        
        mot.rotate(1);                          // Sens de rotation : 1 = pousser, 0 = tirer
        while (switch1 == 0 && switch3 == 0)    // Tant que pas à fond à droite (côte seringue) ou switch3 pas enfonce, on continue
        {  
        }
        mot.stop();
        printf("Veuillez placez la seringue. \n Une fois la seringue mise en place, tapez 1\n");
        scanf("%f", &entree);
        while( entree != 1) {                   // Verifie que l'entree est correcte
            printf("L'entree est incorrecte.\n");
            printf("Une fois la seringue mise en place, tapez 1\n");
            scanf("%f", &entree);
        }
        mot.rotate(0);                          // Puis on repart dans l'autre sens.
        while(gauge2.readRaw() <= 0.4 && switch2 == 0)          //Tant que le contacte n'a pas eu lieu
        { 
        }
        mot.stop();
        printf("Le contact entre la seringue et la fixation est realise.\n");
    }

//////////////////  Actionnement de la seringue  //////////////////

    printf("Voulez-vous travailler en volume ou en debit?\n");
    printf("Pour travailler en volume, tapez 1 \n");
    printf("Pour travailler en debit, tapez 2 \n");
    scanf("%d", &vol_ou_deb);                    // choix : travailler en volume ou en debit
    while( vol_ou_deb != 1 && vol_ou_deb != 2)   // Verifie que l'entree est correcte
    { 
        printf("Une erreur s'est produite quelque part \n");
        printf("Pour travailler en volume, tapez 1 \n");
        printf("Pour travailler en debit, tapez 2 \n");
        scanf("%d", &vol_ou_deb);
    }

//>>>>>>> VOLUME
    if (vol_ou_deb == 1 )
    {
            printf("Veuillez maintenant indiquer le diamètre de la seringue s'il vous plait [mm].\n");
            scanf("%f", &section);
            while( section < 0 || section > 1000)  // Verifie que l'entree est correcte
            {                   
                printf("Une erreur s'est produite quelque part.\n");
                printf("Veuillez indiquer le diametre de la seringue s'il vous plait [mm^2].\n");
                scanf("%f", &section);
            }
            printf("Merci, veuillez maintenant indiquer le volume voulu s'il vous plait [micro-litre].\n");
            scanf("%f", &volume);
            while( volume < 0 && volume > 500000)  // Verifie que l'entree est correcte
            {                   
                printf("Une erreur s'est produite quelque part.\n");
                printf("Veuillez indiquer le volume voulu s'il vous plait [micro-litre]. \n");
                scanf("%f", &volume);
            }
            avance = 192000*volume/(0.25*pi*section*section);//+1000; // Sans micro-pas : 376500 = 1mm; avec micro-pas 192000 = 1mm
    }
//>>>>>>> DEBIT
    if (vol_ou_deb == 2 )
    {
            printf("Veuillez maintenant indiquer le diametre de la seringue s'il vous plait [mm].\n");
            scanf("%f", &section);
            while( section < 0 || section > 1000) // Verifie que l'entree est correcte
            {                   
                printf("Une erreur s'est produite quelque part.\n");
                printf("Veuillez indiquer le diametre de la seringue s'il vous plait [mm].\n");
                scanf("%f", &section);
            }
            printf("Merci, veuillez maintenant indiquer le debit voulu s'il vous plait [micro-litre/ seconde].\n");
            scanf("%f", &debit);
            while( debit < 0 && debit > 2) // Verifie que l'entree est correcte
            {                   
                printf("Une erreur s'est produite quelque part.\n");
                printf("Veuillez indiquer le debit voulu s'il vous plait [micro-litre/seconde]. \n");
                scanf("%f", &debit);
            }
            vitesse = 192000*debit/(0.25*pi*section*section); //Si pas de micro-pas 192000 si micro-pas.
    }

/////////////////// Si pousser //////////////////
    if (mode == 1) 
    {
//>>>>>>> VOLUME
        if (vol_ou_deb == 1)                // Si on travaille en VOLUME
        {   
            printf("Demarrage de l'operation.\n");   
            mot.rotate(1);                  // Sens de rotation : 1 = pousser 0 = tirer
            mot.setPositionZero();
            mot.goesTo(avance);
            
            while(switch1==0)
            {
             if(switch3==1 && paire==0)
                {
                 mot.stop();
                 printf(" ");//printf("Arret temporaire");
                 change = 1;
                }
             if (switch3 == 0 & change == 1)
                {
                 paire = paire +1;
                 paire = paire % 2;
                 change = 0;
                }
             if (switch3 == 1 && paire == 1)
                {   
                printf(" ");//printf("Redemarrage");
                mot.rotate(1);
                mot.goesTo(avance);
                change = 1;
                } 
            }
        }

//>>>>>>> DEBIT
        if (vol_ou_deb == 2)                // Si on travaille en debit
        {   
            printf("Demarrage de l'operation.\n");           
            mot.setSpeed(vitesse);
            mot.rotate(1);                  // Sens de rotation : 1 = pousser 0 = tirer.
            while (switch1 == 0)             // Arret si fin de course
            {
             if(switch3==1 && paire==0)
                {
                 mot.stop();
                 printf(" ");//printf("Arret temporaire");
                 change = 1;
                }
             if (switch3 == 0 & change == 1)
                {
                 paire = paire +1;
                 paire = paire % 2;
                 change = 0;
                }
             if (switch3 == 1 && paire == 1)
                {   
                printf(" ");//printf("Redemarrage");
                mot.setSpeed(vitesse);
                mot.rotate(1);
                change = 1;
                } 
            }
            mot.stop();
            printf("Fin de l'operation.");
        }
    }
/////////////////// Si tirer //////////////////

    if (mode == 2) 
    {
//>>>>>>> VOLUME
        if (vol_ou_deb == 1)                // Si on travaille en VOLUME
        {   
            printf("Demarrage de l'operation.\n");   
            mot.rotate(0);                  // Sens de rotation : 1 = pousser 0 = tirer
            mot.setPositionZero();
            mot.goesTo(avance);
            
            while(switch2==0)
            {
             if(switch3==1 && paire==0)
                {
                 mot.stop();
                 printf(" ");//printf("Arret temporaire");
                 change = 1;
                }
             if (switch3 == 0 & change == 1)
                {
                 paire = paire +1;
                 paire = paire % 2;
                 change = 0;
                }
             if (switch3 == 1 && paire == 1)
                {   
                printf(" ");//printf("Redemarrage");
                mot.rotate(0);
                mot.goesTo(avance);
                change = 1;
                } 
            }
        }

//>>>>>>> DEBIT
        if (vol_ou_deb == 2)                // Si on travaille en debit
        {   
            printf("Demarrage de l'operation.\n");           
            mot.setSpeed(vitesse);
            mot.rotate(0);                  // Sens de rotation : 1 = pousser 0 = tirer.
            //printf("Je tire. \n");      
            while (switch2 ==0)             // Arret si fin de course
            {
             if(switch3==1 && paire==0)
                {
                 mot.stop();
                 printf(" ");//printf("Arret temporaire");
                 change = 1;
                }
             if (switch3 == 0 & change == 1)
                {
                 paire = paire +1;
                 paire = paire % 2;
                 change = 0;
                }
             if (switch3 == 1 && paire == 1)
                {   
                printf(" ");//printf("Redemarrage");
                mot.setSpeed(vitesse);
                mot.rotate(0);
                change = 1;
                } 
            }
        }
    }
 }
