#include "mbed.h"
#include "DebouncedIn.h"

Ticker tick;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DebouncedIn button(p14);

// Zum Schalten: 1 Taster PINA PA0
// 1. Funktion
// Start-Taste 1x betätigen: 
// Dauerlicht aller 4 LEDs
// 2. Funktion
// Start-Taste ein 2.mal betätigen:
// LEDs blinken im ca. 400 Millisekunden-Takt; 200 msec Ein, 200 msec Aus
// Ausschalten des Rücklichts
// Die Start-Taste ein 3.mal betätigen:
// Alle LEDs aus.

int ledsEin();
int ledsBlinkTimer();
int ledsAus();
int ledsSwitchTimer();
int stopTimer();

int(*action[5])()= {ledsSwitchTimer, stopTimer, ledsEin, ledsBlinkTimer, ledsAus };

volatile int event = -1;
volatile int led=0;

void switchled();
void blinkled();

int stopTimer()        
{ 
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    tick.detach();
    event++;
    (action[event])();
    
    return 0;
}

int ledsBlinkTimer()
{
    tick.attach(&blinkled, 0.2);
    return 0;
}

int ledsEin()   
{ 
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    return 0;
}

int ledsAus()   
{ 
    tick.detach();
    event = -1;
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    return 0;
}

int ledsSwitchTimer()
{
    tick.attach(&switchled, 0.2);
    return 0;
}

void ledsTogglen()   
{ 
    led1 = !led1;
    led2 = !led2;
    led3 = !led3;
    led4 = !led4;
}

void switchled()
{
    switch(led)
    {
     case 0: 
        led1 = 1;
        break;
     case 1: 
        led1 = 0;
        led2 = 1;
        break;
     case 2: 
        led2 = 0;
        led3 = 1;
        break;
     case 3: 
        led3 = 0;
        led4 = 1;
        break;
     case 4: 
        led4 = 0;
        led = -1;
        break;
    }
    
    led++;
}

void blinkled()
{
    ledsTogglen();
}

int main()
{    
    while(1) {  
        if (button.rising()) {
            event++;
            (action[event])();
        }
    }
}


