#include "mbed.h"
#include "C12832_lcd.h"

C12832_LCD lcd;

BusOut myled(LED1, LED2, LED3, LED4);
InterruptIn button_up(p15);
InterruptIn button_down(p12);
InterruptIn button_left(p13);

int cnt = 0;

void debounce(PinName name, unsigned char samples)
{
    DigitalIn joystick(name);
    
    for(unsigned char j = 0; j < samples; j++)
    {
        if(joystick == 1)
            j++;
        else
            j = 0;   
            
            if(j == samples)
                break;
    }    
}
void out()
{
    myled = cnt;
    lcd.locate(40, 0);
    lcd.printf("%d      ", cnt);
}

void count()
{
    debounce(p15, 8);
    cnt ++;
    out();
}

void discount()
{
    debounce(p12, 8);
    cnt --;
    out();
}

void clear()
{
    debounce(p13, 8);
    cnt = 0;
    out();
}

int main() {
    
    lcd.cls();
    lcd.printf("Zaehler: ");
    button_up.rise(&count);
    button_down.fall(&discount);
    button_left.rise(&clear);
    while(1) {
        
    }
}
