
class AnalogBuffer {
public:
    AnalogBuffer(){
        index = 0;
        for(int i = 0; i < BUFFER_SIZE; i++) {
            buffer[i] = 0;
        }   
    }
    void put(unsigned short value){
        buffer[index++] = value;
        if (index >= BUFFER_SIZE) {
            index = 0;
        }
    }
    unsigned short average(){
        unsigned short sum = 0;
        for(int i = 0; i < BUFFER_SIZE; i++) {
            sum += buffer[i];
        }
        return sum/BUFFER_SIZE;
    }
private:
    static const int BUFFER_SIZE = 5;
    unsigned short buffer[BUFFER_SIZE];
    int index;
};