#include "mbed.h"
#include "rtos.h"
#include "AnalogBuffer.h"

const int SEUIL_ANALOG = 0x2000;
DigitalIn en_1(p15);
DigitalIn en_2(p16);
AnalogIn ea_1(p19);
AnalogIn ea_2(p20);
bool digital_1;
bool digital_2;
AnalogBuffer ab_1;
AnalogBuffer ab_2;

typedef struct {
    bool isAnalog;
    bool digital;
    unsigned short analog;
    time_t rtc_time;
} mail_t;

Mail<mail_t, 16> mail_box;

void lecture_analog(void const *args) {
    Timer timer;
    unsigned short old_average_1 = 0;
    unsigned short old_average_2 = 0;
    while (true) {
        timer.start(); // synchronisation sur la période d'échantillonnage
        time_t rtc_time = time(NULL); // lecture de l'étampe temporelle
        ab_1.put(ea_1.read_u16()); // lecture des échantillons analogiques
        ab_2.put(ea_2.read_u16());
        unsigned short new_average_1 = ab_1.average(); // calcul de la nouvelle moyenne courante
        unsigned short new_average_2 = ab_2.average();
        int diff_1 = abs(new_average_1 - old_average_1);
        int diff_2 = abs(new_average_2 - old_average_2);
        if (diff_1 > SEUIL_ANALOG) {
            mail_t* mail = mail_box.alloc();
            mail->isAnalog = true;
            mail->analog = new_average_1;
            mail->rtc_time = rtc_time;
            mail_box.put(mail);
        }
        if (diff_2 > SEUIL_ANALOG) {
            mail_t* mail = mail_box.alloc();
            mail->isAnalog = true;
            mail->analog = new_average_1;
            mail->rtc_time = rtc_time;
            mail_box.put(mail);
        }
        old_average_1 = new_average_1;
        old_average_2 = new_average_2;
        Thread::wait(250 - timer.read_ms());
        timer.stop();
        timer.reset(); // Necessaire??
    }
}
void lecture_num(void const *args) {
    Timer timer;
    while (true) {
        timer.start(); // synchronisation sur la période d'échantillonnage
        time_t rtc_time = time(NULL); // lecture de l'étampe temporelle
        bool new_digital_1 = en_1.read();  // lecture des échantillons numériques
        bool new_digital_2 = en_2.read();  // lecture des échantillons numériques
        
        if ((new_digital_1 != digital_1) || (new_digital_2 != digital_2)) {
            // prise en charge du phénomène de rebond
            Thread::wait(50);
            if (new_digital_1 != digital_1) {
                new_digital_1 = en_1.read();
                if (new_digital_1 != digital_1) {
                    // génération éventuelle d'un événement
                    mail_t* mail = mail_box.alloc();
                    mail->isAnalog = false;
                    mail->digital = new_digital_1;
                    mail->rtc_time = rtc_time;
                    mail_box.put(mail);
                    digital_1 = new_digital_1;
                }
            }
            if (new_digital_2 != digital_2) {
                new_digital_2 = en_2.read();
                if (new_digital_2 != digital_2) {
                    // génération éventuelle d'un événement
                    mail_t* mail = mail_box.alloc();
                    mail->isAnalog = false;
                    mail->digital = new_digital_2;
                    mail->rtc_time = rtc_time;
                    mail_box.put(mail);
                    digital_2 = new_digital_2;
                }
            }
        }
        Thread::wait(100 - timer.read_ms());
        timer.stop();
        timer.reset(); // Necessaire??
    }
}

void collection(void const *args) {
    while (true) {
    // attente et lecture d'un événement
    // écriture de l'événement en sortie (port série)
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) {
            mail_t *mail = (mail_t*)evt.value.p;
            if(mail->isAnalog) {
                pc.printf("%s Analog: %X", ctime(&mail->rtc_time), mail->analog);
            } else {
                pc.printf("%s Digital: %d", ctime(&mail->rtc_time), mail->digital);
            }
            mail_box.free(mail);
        }
    }
}

int main() {
    // initialisation du RTC
    // démarrage des tâches
    while(1) {
    }
}