#include "mbed.h"
#include "encoder.h"
#include "HIDScope.h"
#include "PwmOut.h"
/*definieren pinnen Motor 1*/
#define M1_PWM PTA5
#define M1_DIR PTA4
#define M2_PWM PTC8
#define M2_DIR PTC9
/*Definieren minimale waarden PWM per motor*/
#define PWM1_min_30 0.529 /*met koppelstuk!*/
#define PWM2_min_50 0.519 /*aanpassen! Klopt nog niet met koppelstuk*/
/*Definieren om de hoeveel seconden er gegevens naar de HID-scope gestuurd worden.*/
#define TSAMP 0.005
#define I_LIMIT 1.
#define PI 3.1415926535897

Encoder motor1(PTD3,PTD1);
Encoder motor2(PTD5, PTD0); 
PwmOut pwm_motor1(M1_PWM);
PwmOut pwm_motor2(M2_PWM); 
DigitalOut motordir1(M1_DIR);
DigitalOut motordir2(M2_DIR); 
DigitalOut LED(LED_GREEN);

void clamp(float * in, float min, float max);
volatile bool looptimerflag;
int PWM1_percentage = 100;
int PWM2_percentage = 1; 
int aantal_rotaties = 10;
int aantalcr = 960;
int beginpos_motor1;
int beginpos_motor1_new; 
int beginpos_motor2;
int beginpos_motor2_new;
float PWM1 = ((1-PWM1_min_30)/100)*PWM1_percentage + PWM1_min_30; 
float PWM2 = ((1-PWM2_min_50)/100)*PWM2_percentage + PWM1_min_30;
float Speed_motor1;
float Speed_motor1rad;

HIDScope scope(4);

//Ticker tick;
/*void PWMc()
{
    PWM = abs(PWM-0.1);
    pwm_motor1.write(PWM);
    scope.set(0, motor1.getPosition());
    scope.set(1, DigitalIn(PTD3)); 
    scope.set(2, DigitalIn(PTD1)); 
    scope.send();
    }*/
    
void setlooptimerflag(void) //Ticker maakt een constructie die zoveel keer per seconde een functie uitvoerd,  met sampingling freq TSAMP
{
    looptimerflag = true;
}
    
int main() {
    //tick.attach(&PWMc, 5);
    wait(20);
    motor1.setPosition(0);
    beginpos_motor1 = motor1.getPosition();
    beginpos_motor1_new = beginpos_motor1; 
    beginpos_motor2 = motor2.getPosition();
    beginpos_motor2_new = beginpos_motor2; 
    
    Ticker looptimer; // looptimer = variabele van het type ticker(niet int of float), Daarmee is looptimer een classe. Omdat een classe is heeft het methods oftewel functies, zoals attach. Setlooptimerflag is een functie 
    looptimer.attach(setlooptimerflag,TSAMP); // attach betekend het koppelen van een functie aan een classe.   
    LED = 0;
    motordir1 = 0;
    motordir2 = 0; 
    
    while(beginpos_motor1 + aantal_rotaties*aantalcr >= beginpos_motor1_new) {
    pwm_motor1.period_us(100);
    pwm_motor2.period_us(100);
    pwm_motor1.write(PWM1);
    pwm_motor2.write(PWM2);
    beginpos_motor1_new = motor1.getPosition(); 
    Speed_motor1 = (motor1.getSpeed()/30/32); 
    Speed_motor1rad = Speed_motor1*2*PI;
    //while(true) { 
            LED = 1;
            while(!looptimerflag) //Hierdoor zeg je eigenlijk tegen je systeem; voer dit script uit na elke TSAMP s. 
            {
            /*do nothing*/  //Zolang dit waar is, doe je niets. 
            }
            looptimerflag = false; //clear flag
            
        scope.set(0, motor1.getPosition());
        scope.set(1, motor1.getSpeed());
        scope.set(2, Speed_motor1);
        scope.set(3, Speed_motor1rad);  
        scope.send();
        }
        
        pwm_motor1.period_us(100);
        pwm_motor2.period_us(100);
        pwm_motor1.write(0);
        pwm_motor2.write(0);
        
        LED = 0; 
        while(!looptimerflag) //Hierdoor zeg je eigenlijk tegen je systeem; voer dit script uit na elke TSAMP s. 
            {
            /*do nothing*/  //Zolang dit waar is, doe je niets. 
            }
        looptimerflag = false; //clear flag
        scope.set(0, motor1.getPosition());
        scope.set(1, motor1.getSpeed());
        scope.set(2, Speed_motor1);
        scope.set(3, Speed_motor1rad);  
        scope.send();
}