//Script for Robotarm Quartile 9, Group 7

// including all libraries 
//#include "mbed.h"               //Main functionality
//#include "TextLCD.h"            //LCD drivers 
//#include "encoder.h"            //CPR motor counter
//#include "rtos.h"             //Real time operating system(onduidelijk wat deze library doet)
//#include "MODSERIAL.h"        //non-blocking serial communication (RTOS compatible) (onduidelijk wat deze library doet)

#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#include "MODSERIAL.h"
#include "HIDScope.h"
//using namespace std; 
// define MOTOR_POWER_LIMIT     //Veiligheid
// define POSITION_ARM_LIMIT     //Veiligheid
// define SPEED_ARM_LIMIT       //Veiligheid

void accelerometer() {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);

    while (true) {
        rled = 1.0 - abs(acc.getAccX());
        gled = 1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());
        wait(0.1);
    }
}


//Define objects
AnalogIn    emg0(PTB1); //Analog input
PwmOut      red(LED_RED); //PWM output
Ticker log_timer;
MODSERIAL pc(USBTX,USBRX);
HIDScope scope(2);

/** Looper function
* functions used for Ticker and Timeout should be of type void <name>(void)
* i.e. no input arguments, no output arguments.
* if you want to change a variable that you use in other places (for example in main)
* you will have to make that variable global in order to be able to reach it both from
* the function called at interrupt time, and in the main function.
* To make a variable global, define it under the includes.
* variables that are changed in the interrupt routine (written to) should be made
* 'volatile' to let the compiler know that those values may change outside the current context.
* i.e.: "volatile uint16_t emg_value;" instead of "uint16_t emg_value"
* in the example below, the variable is not re-used in the main function, and is thus declared
* local in the looper function only.
**/
void looper()
{
    /*variable to store value in*/    
    uint16_t emg_value;
    /*put raw emg value both in red and in emg_value*/
    red.write(emg0.read());      // read float value (0..1 = 0..3.3V)
    emg_value = emg0.read_u16(); // read direct ADC result (0..4096 = 0..3.3V)
    /*send value to PC. Line below is used to prevent buffer overrun */
    if(pc.rxBufferGetSize(0)-pc.rxBufferGetCount() > 30)
        pc.printf("%u\n",emg_value);
    scope.set(0,emg_value);
    scope.set(1,red.read());
    scope.send();
    /**When not using the LED, the above could also have been done this way:
    * pc.printf("%u\n", emg0.read_u16());
    */
}

void HIDscope()
{
    /*setup baudrate. Choose the same in your program on PC side*/
    pc.baud(115200);
    /*set the period for the PWM to the red LED*/
    red.period_ms(2);
    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.01 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    log_timer.attach(looper, 0.005);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}
int main() 
{
    HIDscope();
    //accelerometer(); 

}


//Nulpositie arm, ook na elke slag (terugkoppeling gebruiker ledje (groen/rood))
//Nulmeting EMG, éénmalig bij opstarten (terugkoppeling gebruiker ledje (groen/rood))
//  Filteren --> werkelijke schaling (referentie)
//Meten EMG 2x(kiezen vlakken hoogte/breedte)
//  RT - Filteren en Verwerking 
//      RT - vergelijking tov van referentie
//      RT - terugkoppeling gebruiker via 3 gekleurde LEDjes (LEDjes aan)
//  Gebruiker akkoord geven nav LEDjes (LEDjes knipperen)
//Akkoord doorsturen motor 2x
//  PWM
//  Direction
//RT - Regelaar
//  RT - Terugkoppeling PWM (Encoder)
//  RT - Terugkoppeling Direction (Encoder)
//Terug naar nulpositie arm
//  Vanaf hier mainscript weer doorlopen, behalve nulmeting EMG
