#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"
#include "TextLCD.h"

/*definieren van de filtercoëfficienten, waarbij A. de y-componenten(output) geven en B. de x-componenten(input)*/
#define A1 -1.3490
#define A2 0.5140
#define B0 0.7157
#define B1 -1.4315
#define B2 0.7157
 
/*aantal kanalen die naar de HIDscope */
HIDScope scope(2); /*Definieren dat we 2 kanalen naar de HID-scope willen sturen*/ 
AnalogIn    emg(PTB1); /*Analog input pin definieren*/
TextLCD lcd(PTD2, PTA12, PTB2, PTB3, PTC2, PTA13, TextLCD::LCD16x2); /*pinnen voor textLCD toeschrijven naar de library tekstLCD, zodat de functies uit die bibliotheek gebruikt kunnen worden*/
float(y); /*y moet een floating point worden(type definieren)*/
float filter(float); /*naar de functie filter willen we een float toeschrijven, welke later gedefinieerd mag worden*/
int main() {
     float x; /*x moet een floating point worden*/ 
     while(true) {
         x = emg.read(); /*het EMG signaal vanaf de pin wordt opgeslagen in x*/
         y = filter(x);  /*x gaat in de filter*/
         scope.set(0, y); /*het bewerkte signaal wordt op kanaal 1 getoont*/
         scope.set(1,emg); /*het ruwe signaal wordt op kanaal 2 getoont*/
         scope.send(); /*Hiermee stuur je de data daadwerkelijk naar je pc*/
         lcd.cls(); /*schoonmaken LCD scherm*/
         /*hieronder een leuke if functie zodat onze display aangeeft of iemand een lage, middel of hoge aanspanning heeft.*/
            if (abs(y) <= 0.05){
                lcd.printf("Lage\naanspanning");
                wait(0.2);                 
                } 
        
            else if (abs(y) >= 0.05 && abs(y) <= 0.10){
                lcd.printf("Middel\naanspanning");
                wait(0.2); 
                }  
                
            else{
                lcd.printf("Hoge\naanspanning");
                wait(0.2); 
                }            
         wait(0.005); /*wacht 0.005s, omdat we meten met 200Hz*/
    }
} 

float filter(float x) { /*de filter functie! Waarbij de x de input is en y de output!*/ 
static float  y, x1, y1, x2, y2; 
y = -A1*y1-A2*y2+B0*x+B1*x1+B2*x2; 
x2 = x1;
x1 = x;
y2 = y1;
y1 = y;   
return y;        
}    
