#include "mbed.h"
#include "BLE.h"
#include "iBeaconScan.h"

Serial pc(TX_PIN_NUMBER, RX_PIN_NUMBER);
DigitalOut led1(LED1);
union unionType u;

void AdvertisementReportCallback(const Gap::AdvertisementCallbackParams_t *params)
{
  led1 = !led1;
  pc.printf("Advertisement packet received.\r\n");
  uint8_t i;
  
  if (memcmp(params->advertisingData,iBeaconPrefix,sizeof(iBeaconPrefix)) != 0){
    pc.printf("Received packet is not ibeacon.\r\n");
    return;
    }
  
  memset(u.rawData, 0 , sizeof(u.rawData));
  memcpy(u.rawData, params->advertisingData,params->advertisingDataLen);

  pc.printf("uuid:");
  for( i = 0; i < 16; i++)
    pc.printf("%02x ",u.iBeaconPayload_m.uuid[i]);
  pc.printf("\r\n");  
  pc.printf("majorNumber:%02x %02x\r\n",u.iBeaconPayload_m.majorNumber[0], u.iBeaconPayload_m.majorNumber[1]);
  pc.printf("minorNumber:%02x %02x\r\n",u.iBeaconPayload_m.minorNumber[0], u.iBeaconPayload_m.minorNumber[1]);
  pc.printf("txPower:%d\r\n",u.iBeaconPayload_m.txPower);
  pc.printf("RSSI:%d\r\n",params->rssi);
}

int main(void)
{   
    led1 = 0;
    pc.baud(115200);
    wait(10);
    pc.printf("Hello\r\n"); 
    
    pc.printf("Start initialization\r\n");
    iBeaconInit();
    pc.printf("Finish initialization\r\n");
    wait(10);
    pc.printf("Start Scan\r\n");
    iBeaconStartScan();
    pc.printf("Scanning..\r\n");
    //wait(10);
    //iBeaconStopScan();
    //pc.printf("Scan stop.\r\n");
    
    while(1) { 
        //pc.printf("Hello\r\n");
        //led1 = !led1;
        //wait(1);
    }
}
