#include "mbed.h"
#include "M2XStreamClient.h"
#include "include_me.h"

using namespace mts;

const char key[] = "1f706ed9764457981e61b427767f65a5";
const char feed[] = "5996c26815bd3245c8ec35089d51b614";
const char stream[] = "test_test_test";

int main() {
    /* bring up PPP link */
    /*
    MTSSerialFlowControl* serial = new MTSSerialFlowControl(PTD3, PTD2, PTA12, PTC8);
    serial->baud(115200);
    Cellular* cell = Cellular::getInstance();
    cell->init(serial);

    int max_tries = 5;
    int i;
    std::string apn = "wap.cingular";
    
    wait(10);
    printf("waiting for radio to come up\n\r");
    wait(10);
    
    i = 0;
    while (i++ < max_tries) {
        if (cell->getRegistration() == Cellular::REGISTERED) {
            printf("registered with tower\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to register with tower\n\r");
        } else {
            wait(3);
        }
    }
    
    i = 0;
    while (i++ < max_tries) {
        if (cell->setApn(apn) == SUCCESS) {
            printf("successfully set APN\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to set APN\n\r");
        } else {
            wait(1);
        }
    }
    
    i = 0;
    while (i++ < max_tries) {
        if (cell->connect()) {
            printf("PPP link is up\n\r");
            break;
        } else if (i >= max_tries) {
            printf("failed to bring PPP link up\n\r");
        } else {
            wait(1);
        }
    }
    
    if (! cell->isConnected()) {
        printf("could not connect\n\r");
        return 1;
    }
    */
    
    printf("Program Started\n\r");
    MTSSerial* serial = new MTSSerial(PTD3, PTD2, 256, 256);
    serial->baud(9600);
    Transport::setTransport(Transport::WIFI);
    Client client;
    //M2XStreamClient m2xClient(&client, key, "54.214.25.232");
    M2XStreamClient m2xClient(&client, key);
    Wifi* wifi = Wifi::getInstance();
    printf("Init: %s\n\r", wifi->init(serial) ? "SUCCESS" : "FAILURE");
    printf("Set Network: %s\n\r", getCodeNames(wifi->setNetwork("Multi-Tech", Wifi::WPA2, "VivaLasVegas2014")).c_str());
    //printf("Set Static: %s\n\r", getCodeNames(wifi->setDeviceIP("192.168.18.164")).c_str());
    printf("Set DHCP: %s\n\r", getCodeNames(wifi->setDeviceIP("DHCP")).c_str());
    printf("Signal Strnegth (dBm): %d\n\r", wifi->getSignalStrength());
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
    printf("Connect: %s\n\r", wifi->connect() ? "Success" : "Failure");
    printf("Is Connected: %s\n\r", wifi->isConnected() ? "True" : "False");
    
    /* send some data */
    int ret;
    int num;
    while (true) {
        num = rand();
        printf("sending %d\r\n", num);
        ret = m2xClient.send(feed, stream, num);
        printf("send() returned %d\r\n", ret);
        wait(5);
    }
}