#include "mbed.h"
#include "PinDetect.h"
#include "USBKeyboard.h"
#include "DebounceIn.h"

#define PINDETECT_SAMPLE_FREQUENCY 10000

DigitalOut led(LED_GREEN);
DebounceIn mode(D12);
DebounceIn accelerate(D11);
DebounceIn powerUp(D10);
DebounceIn breakz(D13);
DebounceIn up(D9); 
DebounceIn down(D7); 
DebounceIn left(D6); 
DebounceIn right(D8);

HID_REPORT report;

AnalogIn accelZ(A0);
AnalogIn accelY(A1);
AnalogIn accelX(A2);
 
//USBMouseKeyboard
USBKeyboard controller;

//X: 0.48 - 0.51
//Z: 0.47 - 0.57
float CENTER_LEFT = 0.48;
float CENTER_RIGHT = 0.51;
float CENTER_UP = 0.47;
float CENTER_DOWN = 0.57;
int flag = 1; // to change modes between directions via 1.buttons or 2.accelerometer
 
int main(void) {
    report.data[0] = 1;
    report.length = 9;
    while (true) {
        if (!mode) {
            flag = !flag;
            wait(0.5);
        }
        
        //KL25Z Debugging Purposes
        led=!led;
        wait(0.05);
        
        //Mode 1: Accelerometer
        if (flag) {
            if (!accelerate) { 
                report.data[3] = 0x1B; //x 
            } else {
                report.data[3] = 0;
            }
            if (!powerUp) { 
                report.data[8] = 0x16; //s
            } else {
                report.data[8] = 0;
            }
            if (accelX.read() <= CENTER_LEFT) {
                report.data[4] = 0x50;
            } else {
                report.data[4] = 0;
            }
            if (accelX.read() >= CENTER_RIGHT) {
                report.data[5] = 0x4F;
            } else {
                report.data[5] = 0;
            }
            if (accelZ.read() <= CENTER_UP) {
                report.data[6] = 0x52;
            } else if (!breakz) {
                report.data[6] = 0x1D; //z
            } else {
                report.data[6] = 0;
            }
            if (accelZ.read() >= CENTER_DOWN) {
                report.data[7] = 0x51;
            } else {
                report.data[7] = 0;
            }
            controller.send(&report);
        }

        //Mode 2: Buttons 
        if (!flag) {
            if (!accelerate) { 
                report.data[3] = 0x1B; //x 
            } else {
                report.data[3] = 0;
            }
            if (!powerUp) { 
                report.data[8] = 0x16; //s
            } else {
                report.data[8] = 0;
            }
            if (!up) { 
                report.data[4] = 0x52; 
            } else if (!breakz) {
                report.data[4] = 0x1D; //z
            } else {
                report.data[4] = 0;
            }
            if (!down) {
                report.data[5] = 0x51;
            } else {
                report.data[5] = 0;
            }
            if (!left) {
                report.data[6] = 0x50;
            } else {
                report.data[6] = 0;
            }
            if (!right) {
                report.data[7] = 0x4F;
            } else {
                report.data[7] = 0;
            }
            controller.send(&report);
        }
    }
}