#include "mbed.h"
#include "door.h"
#include "elevator.h"
#include "hcsr04.h"
#include "DebouncedIn.h"

#define FLOOR_1 12
#define FLOOR_2 24
#define FLOOR_3 36
#define ID_DOORS 1
#define ID_ELEVATOR 2

void GoTo(void);
void Doors(void);
void Leds(void);
void Buttons(void);

Thread Thread_goto(osPriorityNormal);
Thread Thread_doors(osPriorityNormal);
Thread Thread_leds(osPriorityNormal);
Thread Thread_buttons(osPriorityNormal);

Door door_1(PTD0);
Door door_2(PTD5);
Door door_3(PTA13);

Elevator elevator1(PTB3, PTC1, PTC2);

HCSR04 sensor(PTD3, PTD1);

DebouncedIn floor1(PTC11);
DebouncedIn floor2up(PTC10);
DebouncedIn floor2down(PTC6);
DebouncedIn floor3(PTC5);
DebouncedIn floor1int(PTC4);
DebouncedIn floor2int(PTC3);
DebouncedIn floor3int(PTC0);
DebouncedIn stop(PTC7);

DigitalOut led1(PTE5);
DigitalOut led2(PTE4);
DigitalOut led3(PTE3);

int floor_ = FLOOR_1;
int pos_sensor = 0;

int main()
{
    
    // Thread_goto.start(GoTo);
    // Thread_doors.start(Doors);
    // Thread_buttons.start(Buttons);
    // Thread_leds.start(Leds);
    
    while(true) 
    {   
        door_1.open();
        wait_ms(3000);
        door_1.close();
        wait_ms(3000);
    }
}

void Leds(void)
{
    while (true)
    {
        switch(pos_sensor){
           case FLOOR_1:
                led1=1;
                led2=0;
                led3=0;
           break;
           case FLOOR_2:
                led1=0;
                led2=1;
                led3=0;    
           break;
           case FLOOR_3:
                led1=0;
                led2=0;
                led3=1;    
           break;
           } 
    }
}

void GoTo(void)
{
    int flag=0;
    while(true) 
    {    
        if(pos_sensor<floor_-1) {
            elevator1.go_up();
            flag=0;
            
        } else {
            if(pos_sensor>floor_+1) {
                elevator1.go_down();
                flag=0;
            } else {
                elevator1.off();
                if(flag==0)
                {
                Thread_doors.signal_set(ID_DOORS);
                Thread::signal_wait(ID_ELEVATOR);
                flag=1;
                }
            }
        }
        Thread::wait(100);
    }
}

void Doors(void)
{
    while(true) {
       Thread::signal_wait(ID_DOORS);
       switch(floor_){
           case FLOOR_1:
                    door_1.open();
                    Thread::wait(3000);
                    door_1.close();
           break;
           case FLOOR_2:
                    door_2.open();
                    Thread::wait(3000);
                    door_2.close();
           break;
           case FLOOR_3:
                    door_3.open();
                    Thread::wait(3000);
                    door_3.close();
           break;
           }
           Thread_goto.signal_set(ID_ELEVATOR);
    }
}

void Buttons(void)
{
    while(true)
    {
        if(floor1.rising()||floor1int.rising())
        {
            floor_=FLOOR_1;
        }
        if(floor2up.rising()||floor2int.rising()||floor2down.rising())
        {
            floor_=FLOOR_2;
        }
        if(floor3.rising()||floor3int.rising())
        {
            floor_=FLOOR_3;
        }
    }
}