#include "SoftSerial.h"
#include "SerialGPS.h"
//#include "GPSPARSER.h"

Serial pc(USBTX, USBRX);

int main(void)
{
    pc.baud(115200);
#ifdef DEMO_ONLY
    SoftSerial *softUART = new SoftSerial(D6, D7);
    softUART->baud(9600);
    softUART->puts("Hello\r\n");
    while(true){
        int c = softUART->getc();
        softUART->putc(c);
    }
#endif
    DigitalOut led(D0);
    SerialGPS gps(D6, D7, 9600);
    
    while(true){
        if(gps.sample() > 0){
            pc.printf("Last longitude degrees were... %f\r\n", gps.longitude);
            pc.printf("Last latitude degrees were... %f\r\n", gps.latitude);
            led = true;
        } else {
            pc.printf("No lock\r\n");
            led = false;
        }
        wait(5);
    }
    
    return 0;
}
