#include "mbed.h"
#include "MSCFileSystem.h"
#include "C12832.h"

MSCFileSystem fs("usb"); 

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);
Ticker mesures;

DigitalIn  bouton(p14); // pour pouvoir controler la fin de l'enregistrement
C12832 lcd(p5, p7, p6, p8, p11); 
I2C i2c(p28, p27);//

Timer  timer1; // un Timer pour mesurer le temps


char  data[2]; 
unsigned short alt, mes_alt, valeur;
unsigned char flag_alt,flag_100ms;

#define ALT_ADDR  0xEC
#define ET_S1 0
#define ET_S2 1
#define ET_S3 2
#define ET_S4 3

void auto_alti(){
    static unsigned char etat_alti=ET_S1;    
    static char  ldata[2]; 
    static unsigned char ltemp,ltemp2=0;
    switch (etat_alti) {
        case ET_S1 : 
                    ldata[0] = 0x07; // Send "register number" command to sensor 
                    i2c.write(ALT_ADDR, ldata, 1); // Send command string
                    etat_alti= ET_S2;
                    ltemp=0;
                    break;
        case ET_S2 : if(ltemp++ >=13){
                       etat_alti=ET_S3;
                       ltemp=0;
                     }
                     break;
        case ET_S3 : 
                    i2c.read(ALT_ADDR, ldata, 2);
                    alt = *((unsigned short*)ldata)&0xffff; //altitude en décimètre
                    alt = alt-3000;
                    flag_alt=1;
                    etat_alti=ET_S1;
                    break;
        default : break;
    }
    if(ltemp2++ >=100){
            flag_100ms=1;
            ltemp2=0;
    }
}

int main() 
{       
    unsigned long tk2=0; // des variables pour stocker les temps de mesure
    i2c.frequency (100000) ;//void frequency(int hz);
    lcd.cls(); // effacer LCD
    led1=0;   
    led2=0;
               
    FILE *FDat = fopen("/usb/FileTtest1.csv", "w");//ajouter un nouveau fichier excel et écraser l'ancien
    led1=1;
    mesures.attach_us(&auto_alti,1000);
    if(FDat==NULL) { 
        led4=1;
        while(1);
    }    
    while(bouton==0) {          
            if(flag_alt==1) {
                mes_alt=alt;
                flag_alt=0;
                timer1.reset();
                timer1.start();
                fprintf(FDat,"%lu;%d;%d\r\n",tk2,alt);
                tk2=timer1.read_us(); // je mesure le temps d'écriture de la fonction fprintf
                led2=!led2;
                
            }
            if(flag_100ms==1){
            //------------------------affichage de l information de V4       
                    lcd.locate(0,15);
                    lcd. printf("alt = %6u", mes_alt);
                    flag_100ms=0;
            }
            
    }
    fclose(FDat);
    led1=0;
    led2=0;
}

