#include "mbed.h"
#include "MSCFileSystem.h"
#include "C12832.h"

MSCFileSystem fs("usb"); 

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);

DigitalIn  bouton(p14); // pour pouvoir controler la fin de l'enregistrement
C12832 lcd(p5, p7, p6, p8, p11); 
I2C i2c(p28, p27);//

Timer  timer1; // un Timer pour mesurer le temps

unsigned int addr = 0xEA;// I2C ADRESS from datashee

char  data[2]; 
unsigned  int vbrut, offset_v;
float vitesse;
unsigned long tk1,tk2; // des variables pour stocker les temps de mesure
int main() 
{ 

     
      
     i2c.frequency (100000) ;//void frequency(int hz);
   
     lcd.cls();// effacer LCD
  
     
    
    data[0] = 0x01; // Send "read data" command to sensor 
    i2c.write(addr, data, 1); // Send command string
    wait_us(400);//attendre 100µS avant de relancer
    i2c.read(addr, data, 2);
    offset_v=(0xff00 & ( ((unsigned)data[1]) << 8)) + ((unsigned char)data[0]&0xff);      
       
    led1=0;   
    led2=0;
               
    FILE *FDat = fopen("/usb/FileTtest1", "w");//ajouter un nouveau fichier et écraser l'ancien
    led1=1;
    if(FDat==NULL) { 
        led4=1;
       // while(1);
    }    
    tk1=0;
    while(bouton==0) {
            timer1.reset();
            timer1.start();
            
            data[0] = 0x01; // Send "register number" command to sensor 
            i2c.write(addr, data, 1); // Send command string
            wait_us(400);//attendre 400µS avant de relancer
            i2c.read(addr, data, 2);
           
             
            vbrut =  (0xff00 & ( ((unsigned)data[1]) << 8)) + ((unsigned char)data[0]&0xff);
            vitesse = sqrt((float)(vbrut-offset_v)*2*3.6/1.225);
            
            data[0] = 0x01; // Send "register number" command to sensor 
            wait_us(400);
            i2c.write(addr, data, 1); // Send command string
            wait_us(400);//attendre 100µS avant de relancer
            i2c.read(addr, data, 2);
            
            tk1=timer1.read_us();
           
            fprintf(FDat,"%lu  %lu  %f  %u\r\n",tk1,tk2,vitesse,vbrut);
          
            tk2=timer1.read_us(); // je mesure le temps d'écriture de la fonction fprintf
            led2=!led2;
            wait(0.1);
            //------------------------affichage de l information de V4       
            lcd.locate(1,15);
            lcd. printf("sp = %f", vitesse);
            wait(0.4);    
    }
    fclose(FDat);
    led1=0;
    led2=0;
}

/*les résultats de  test de programme sont :

2330  2381  6.857143  1511 ******************************************************
2329  2381  7.273098  1512
2330  2381  8.040712  1514
2330  4597  6.414270  1510           avant d'allumer les extracteur 
2329  2381  7.273098  1512
2329  2381  8.398251  1515
2330  2381  5.938460  1509
2330  2382  6.857143  1511 *************************************************
2330  2382  11.876920  1527
2329  2383  10.842094  1523
2330  2382  9.697464  1519
2330  2382  9.995917  1520
2329  2381  8.398251   1515
2329  2380  11.371285  1525
2331  2382  12.828540  1531
2333  2384  11.371285  1525
2329  2386  9.071147   1517              demmarage de l'extracteur , mais j'ai ete pas stable 
2329  2381  13.278800  1533
2329  2382  15.333037  1543
2329  2382  12.361890  1529
2330  2382  13.498300  1534
2329  5145  11.876920  1527
2330  2382  10.842094  1523
2329  2383  8.040712  1514
2329  2381  12.597376  1530
2329  2382  12.121831  1528
2331  2382  13.926923  1536
2330  2383  14.746843  1540
2329  2383  11.876920  1527
2329  2382  13.926923  1536
2329  2382  15.711688  1545
2330  2382  11.109841  1524
2330  2383  13.926923  1536
2331  2383  11.626851  1526
2330  2383  12.121831  1528
2330  2383  13.278800  1533
2329  2383  10.285714  1521
2329  2382  12.121831  1528
2329  2382  10.285714  1521
2330  4646  12.597376  1530
2330  2383  12.828540  1531
2330  2383  13.714286  1535
2330  2383  10.567567  1522
2329  2383  14.546197  1539
2329  2382  11.626851  1526
2329  2382  14.342743  1538
2330  2382  14.342743  1538
2329  2383  14.944797  1541
2329  2382  13.714286  1535
2330  2382  13.055611  1532
2331  2383  11.876920  1527
2330  2384  11.876920  1527
2329  2383  12.828540  1531
2329  2382  12.828540  1531
2329  2382  9.697464  1519
2330  2381  9.389529  1518
2329  4793  7.666519  1513
2331  2381  5.938460  1509
2329  2382  4.848732  1507
2329  2381  10.285714  1521
2330  2382  9.071147  1517
2330  2381  11.371285  1525
2329  2383  9.389529  1518
2329  2381  10.285714  1521
2329  2382  11.626851  1526
2329  2382  14.136362  1537
2329  2382  13.055611  1532
2329  2382  14.136362  1537
2329  2382  14.546197  1539
2329  2382  14.546197  1539
2330  2382  13.055611  1532
2329  2383  10.285714  1521
2329  2382  11.626851  1526
2330  2382  9.071147  1517
2330  4922  11.109841  1524
2329  2383  10.842094  1523
2330  2382  12.597376  1530
2329  2383  7.273098  1512
2329  2381  7.273098  1512
2329  2381  8.040712  1514
2331  2381  8.398251  1515
2331  2382  8.398251  1515
2330  2382  9.697464  1519
2329  2382  8.741177  1516
2330  2381  9.697464  1519
2330  2381  11.876920  1527
2331  2383  15.523518  1544*************************************************************************************************
2329  2384  15.523518  1544
2330  2382  15.140162  1542
2329  2383  13.926923  1536
2331  2382  14.944797  1541
2330  2384  16.081425  1547
2329  5093  15.897632  1546
2331  2382  15.333037  1543      dans cette partie j'ai pas bougé le tube de pitot
2330  2383  16.796501  1551
2332  2383  16.796501  1551
2330  2384  16.442850  1549
2329  2383  17.482353  1555
2330  2382  15.523518  1544
2329  2383  16.620617  1550
2329  2382  15.711688  1545
2330  2382  14.944797  1541
2329  2383  15.333037  1543
2329  2382  16.263142  1548
2330  2382  16.796501  1551****************************************************************************************************

*/
