#include "XBEE.h"

XBEE::XBEE(PinName tx, PinName rx, PinName reset)
{
    _tx = tx;
    _rx = rx;
    _reset = reset;
    _TCOMXbee = new Serial(_tx,_rx);
}
void XBEE::Init(unsigned int baud){
    
    _TCOMXbee->baud(baud);    
    wait_ms(100);
    Reset();

}
void XBEE::SendMSG(char *buf){
        
    _TCOMXbee->printf("%s",buf);    
}
void XBEE::RecieveMSG(char *buf){
        
    _TCOMXbee->printf("%s",buf);    
}
void XBEE::Reset(){
    DigitalOut XbeeRST(_reset);
    XbeeRST = 0;
    wait_ms(10);
    XbeeRST = 1;
    wait_ms(1);
}