#include "mbed.h"
#include "C12832.h"
#include "MSCFileSystem.h"
//-----------------------
#include "Define.h"
#include "Dec_GPS.h"
//-----------------------
MSCFileSystem fsLog("USB");    //  Enregsetement des doonées "Flash Disque USB"
FILE    *Fs_Log;
I2C     _I2C(p28,p27);         //  I2C    SCL,SDA
Serial  _ComGPS(NC, p14);     //  TX non connecté, pin14 RX.
Serial  _ComXbee(p9,p10);      //  Serial tx(p9),rx(10)
#define  pRST_Xbee   p30       //  pin RST Xbee
Ticker  _Ticker1ms;
Timer   _Timer1;               // Timer pour mesurer le temps

DigitalIn  boutonStart(p13);   // Joystique Left  : Boutton pour pouvoir controler le debut de l'enregistrement
DigitalIn  boutonEnd(p16);     // Joystique Right : Boutton pour pouvoir controler la fin de l'enregistrement

DigitalOut  RSTXbee (p30);
DigitalOut  LedGPS  (LED1);
DigitalOut  LedLog  (LED2);
DigitalOut  LedXbee (LED3);
DigitalOut  LedError(LED4);
//-----------------------
StructGPS GPS,OldGPS;
unsigned long TimeBtpress=0,TIMER_10ms;
unsigned long FileIndex0,FileIndex;
char          Txt[16],Txt_Log[100],Txt_Tx2GSC[100],DataLogFileName[32];
//----------------------------------- Reception des données GPS  10Hz

void AutoMat_GPS()
{
    static unsigned char i=0,j=0,GPSDataType=0,ET_AutoMat_GPS=ET_01;
    static char gps_mess;
    while(_ComGPS.readable()) {
        gps_mess=_ComGPS.getc();

        switch(ET_AutoMat_GPS) {
            case ET_01:
                if(gps_mess==prompt$GP[i]) {
                    i++;
                    if(i==3) {
                        i=0;
                        j=0;
                        ET_AutoMat_GPS=ET_02;
                    }
                } else i=0;
                break;
            case ET_02:
                if(gps_mess==promptGGA[i]) {
                    i++;
                    if(i==3) {
                        i=0;
                        j=0;
                        ET_AutoMat_GPS = ET_03;
                        GPSDataType = GGA;
                    }
                    break;
                } else i=0;

                if(gps_mess==promptRMC[j]) {
                    j++;
                    if(j==3) {
                        j=0;
                        ET_AutoMat_GPS=ET_03;
                        GPSDataType=RMC;
                    }
                    break;
                } else j=0;

                ET_AutoMat_GPS=ET_01;
                break;

            case ET_03:
                _MsgGPSRx[i]=gps_mess;
                i++;
                if((i<NData_GPS_Max)&&(gps_mess!=0x0D))break;

                switch(GPSDataType) {

                    case GGA:
                        DecodageGPGGA(MsgGPSRx,i-1,&OldGPS);// l'appel de la fonction de decodage du message GPGGA                        
                        if (OldGPS.GGA_Valid == 0x01) {                            
                            OldGPS.GGA_Valid = 0x00;                            
                            LedGPS = !LedGPS;
                        }
                        break;
                    case RMC: //DecodageGPRMC(i-1);// l'appel de la fonction de decodage du message GPGGA  //DecodageGPRMC(i-1);
                        break;
                    default:
                        break;
                }
                ET_AutoMat_GPS=ET_01;
                GPSDataType = NULL;
            default :
                break;
        }
    }
}
//----------------------------------- Transmission données au sol 10 packet/s
void AutoMat_Xbee_Tx()
{
   static char LIndex=0;
    switch  (ET_AutoMat_Xbee_Tx) {
        case ET_01:
             LIndex++;                    
             ET_AutoMat_Xbee_Tx = ET_00;
             if(LIndex>=5) ET_AutoMat_Xbee_Tx = ET_02;
            break;
        case ET_02:            
            LIndex = 0;
            LedXbee = !LedXbee;
            sprintf(Txt_Tx2GSC,"$TIME:%lu\r\n",OldTIMER_10ms);
            _ComXbee.printf("%s",Txt_Tx2GSC);
            ET_AutoMat_Xbee_Tx = ET_03;
            break;
        case ET_03 :
            sprintf(Txt_Tx2GSC,"!!!UTC:%2u%2u%2u,***\r\n",GPS.hh,GPS.mm,GPS.ss);
            _ComXbee.printf("%s",Txt_Tx2GSC);
            ET_AutoMat_Xbee_Tx = ET_04;
            break;
        case ET_04 :           
            //delay 10ms
            ET_AutoMat_Xbee_Tx = ET_05;
            break;
        case ET_05 :                   
            sprintf(Txt_Tx2GSC,"!!!LAT:%ld,LON:%ld,***\r\n",GPS.LatDeg,GPS.LonDeg);
            _ComXbee.printf("%s",Txt_Tx2GSC);
            ET_AutoMat_Xbee_Tx = ET_06;
            break;
        case ET_06 :
            //delay 10ms
            ET_AutoMat_Xbee_Tx = ET_07;
            break;
        case ET_07 :                   
            sprintf(Txt_Tx2GSC,"!!!PCH:%.2f,RLL:%.2f,CRS:%.2f,SPD:%.2f,ALT:%.2f,***\r\n",HK_PCH,HK_RLL,HK_CRS,HK_SPD,HK_ALT);  
            _ComXbee.printf("%s",Txt_Tx2GSC);
            ET_AutoMat_Xbee_Tx = ET_08;       
            break;
        case ET_08 :
            ET_AutoMat_Xbee_Tx = ET_00;
            break;        
        default:
            ET_AutoMat_Xbee_Tx=ET_00;
            break;
    }
}
//----------------------------------- LogData 100Hz,  LogGPS 10Hz
#ifdef EN_AutoMat_DataLog
void AutoMat_DataLog()
{
    static char ET_Sub_AutoMat = ET_00;
    switch  (ET_AutoMat_DataLog) {

        case ET_01:
            LedLog=!LedLog;
            //--------------
            // au max 100us    (0.1ms)
            sprintf(Txt_Log,"%lu;GPS;%1u;%2u:%2u:%2u;%10ld;%10ld;%ld;",TIMER_10ms,GPS.Qual,GPS.hh,GPS.mm,GPS.ss,GPS.LatDeg,GPS.LonDeg,GPS.HMSL);
            // au max 5000 us  (5ms)
            fprintf(Fs_Log,Txt_Log);
            // 100us
            sprintf(Txt_Log,"P;%5d;%5d;%5d;%5d\r\n",CRS,ALT,SPD,TEM);
            // au max 5 ms
            fprintf(Fs_Log,Txt_Log);
            //------------------
            ET_Sub_AutoMat     = ET_01;
            ET_AutoMat_DataLog = ET_02;
            break;
        case ET_02:
            // au max 100us    (0.1ms)
            sprintf(Txt_Log,"%lu;;;;;;;",TIMER_10ms);
            // au max 5000 us  (5ms)
            fprintf(Fs_Log,Txt_Log);
            // au max 100us    (0.1ms)
            sprintf(Txt_Log,"P;%5d;%5d;%5d;%5d\r\n",CRS,ALT,SPD,TEM);
            // au max 5000 us  (5ms)
            fprintf(Fs_Log,Txt_Log);
            ET_Sub_AutoMat++;
            if(ET_Sub_AutoMat>=ET_10) ET_AutoMat_DataLog = ET_00;
            break;

        default:  break ;
    }
}
#endif
//------------------------------------------ Sansors
void AutoMat_ALT_EAGLE_V4()
{
    static char  L_i2c_Data[2],LIndex,Lerror;
    switch (ET_AutoMat_ALT) {
        case ET_01 :
            L_i2c_Data[0] = 0x07; // Send "register number" command to sensor
            Lerror = _I2C.write(Add_Sensor_ALT_EG4, L_i2c_Data, 1,true); // Send command string
            if (Lerror==0) ET_AutoMat_ALT = ET_02;
            LIndex = 1;
            break;
            
        case ET_02 : 
             LIndex++;
             if(LIndex>=Wait_Time1_ms) ET_AutoMat_ALT = ET_03;
             break;
                            
        case ET_03 :
            Lerror = _I2C.read(Add_Sensor_ALT_EG4, L_i2c_Data, 2, true);
            if (Lerror==0) {
                ALT = *((unsigned short*)L_i2c_Data)&0xffff; //altitude en décimètre
                ALT = ALT-3000;
            }
            ET_AutoMat_ALT = ET_01;
            break;
        default :  break;
    }
}

void AutoMat_TAS_EAGLE_V4()
{
    static char  L_i2c_Data[2],LIndex,Lerror;
    unsigned short SPD_short;
    float SPD_float;
    switch (ET_AutoMat_TAS) {
        case ET_01 :
            L_i2c_Data[0] = 0x07; // Send "register number" command to sensor
            Lerror = _I2C.write(Add_Sensor_TAS_EG4, L_i2c_Data, 1,true); // Send command string
            if (Lerror==0) ET_AutoMat_TAS = ET_02;
            LIndex = 1;
            break;
            
        case ET_02 : 
             LIndex++;
             if(LIndex>=Wait_Time1_ms) ET_AutoMat_TAS = ET_03;
             break;
                            
        case ET_03 :
            Lerror = _I2C.read(Add_Sensor_TAS_EG4, L_i2c_Data, 2, true);
            if (Lerror==0) {
                SPD_short = *((unsigned short*)L_i2c_Data)&0xffff; 
                SPD_float = 10*sqrt((float)(SPD_short-Offset_SPD)*5.87755102);
                SPD = 10*SPD_float; // mph*10
            }
            ET_AutoMat_TAS = ET_01;
            break;
        default :
            break;
    }
}
void AutoMat_CAP_HMC()
{
    static char  L_i2c_Data[2],LIndex,Lerror;
    switch (ET_AutoMat_CAP) {
        case ET_01 :
            L_i2c_Data[0] = 0x07; // Send "register number" command to sensor
            Lerror = _I2C.write(Add_Sensor_CAP_HMC, L_i2c_Data, 1,true); // Send command string
            if (Lerror==0) ET_AutoMat_CAP = ET_02;
            LIndex = 1;
            break;
            
        case ET_02 : 
             LIndex++;
             if(LIndex>=Wait_Time1_ms) ET_AutoMat_CAP = ET_03;
             break;
                            
        case ET_03 :
            Lerror = _I2C.read(Add_Sensor_CAP_HMC , L_i2c_Data, 2, true);
            if (Lerror==0) {
                CRS = *((unsigned short*)L_i2c_Data)&0xffff; //Cap en deg*10
            }
            ET_AutoMat_CAP = ET_01;
            break;
        default :
            break;
    }
}

void AutoMat_TEM_LM75B()
{
    static char  L_i2c_Data[2],LIndex,Lerror;
    switch (ET_AutoMat_TEM) {
        case ET_01 :
            L_i2c_Data[0] = 0x07; // Send "register number" command to sensor
            Lerror = _I2C.write(Add_Sensor_TEM_LM75B, L_i2c_Data, 1,true); // Send command string
            if (Lerror==0) ET_AutoMat_TEM = ET_02;
            LIndex = 1;
            break;
            
        case ET_02 : 
             LIndex++;
             if(LIndex>=Wait_Time1_ms) ET_AutoMat_TEM = ET_03;
             break;
                            
        case ET_03 :
            Lerror = _I2C.read(Add_Sensor_TEM_LM75B, L_i2c_Data, 2, true);
            if (Lerror==0) {
               // CRS = *((unsigned short*)L_i2c_Data)&0xffff; //Cap en deg*10
            }
            ET_AutoMat_TEM = ET_01;
            break;
        default :
            break;
    }
}
//----------------- LCD ------------
void AutoMat_LCD_Ext()
{
    static char Lerror;
    switch (ET_AutoMat_LCD) {
        case ET_01 :            
            Lerror = _I2C.write(Add_LCD_Ext, NULL, 0,true);
            if (Lerror==0) ET_AutoMat_LCD = ET_02;
            break;
        case ET_02 :
            // Code ici 
            ET_AutoMat_LCD = ET_01;
            break; 
        default :
            break;
    }
}
//---------------------------------

void Sansors_Init()
{
    char  L_i2c_Data[3];
    //------------ init Compass HMC //Continuous mode, periodic set/reset, 20Hz measurement rate.
    L_i2c_Data[0] = HMC6352_CONTINUOUS;
    L_i2c_Data[1] = 0x01;
    L_i2c_Data[2] = 20;
    _I2C.write(Add_Sensor_CAP_HMC,L_i2c_Data,3); // Send command
    //----------------------------
    wait_ms(1);         //attendre 1mS
    //------------- Get Offset TAS
    L_i2c_Data[0] = 0x01; // Send "read data" command to sensor
    _I2C.write(Add_Sensor_TAS_EG4,L_i2c_Data,1); // Send command string
    wait_ms(1);         //attendre 400µS avant de relancer
    _I2C.read(Add_Sensor_TAS_EG4,L_i2c_Data, 2);
    Offset_SPD = *((unsigned short*)L_i2c_Data)&0xffff; // Altitude en décimètre
}

void Irq01ms()
{
    static unsigned char LFlag_Timer=0, LTIMER001ms=0,LTIMER010ms=0;
    LTIMER001ms++;
    LFlag_Timer  = 1;
    //-----------------------------
    if(LTIMER001ms >= 10) {
        //-----------------
        LTIMER001ms = 0; 
        LFlag_Timer = 3;
        LTIMER010ms = LTIMER010ms+1;        
        //-----------------
        if(LTIMER010ms >= 10) {
            LTIMER010ms  = 0;
            LFlag_Timer  = 7;
        }
        //-----------------
        TIMER_10ms  = TIMER_10ms+1;  
    }
    AutoMat_ALT_EAGLE_V4();
    AutoMat_TAS_EAGLE_V4();
    AutoMat_CAP_HMC();
    AutoMat_TEM_LM75B();// temperateur LM75B
    
    if (Flag_Timer != 0xFF) Flag_Timer = LFlag_Timer;
    //-----------------------------
}

int main()
{
    
    CRS = 0;
    SPD = 0;
    ALT = 0;
    LedError = 0;
    //--------------------
    _I2C.frequency(100000);
    _ComGPS.baud(38400); //GPS V4 EAGLE
    _ComGPS.attach(&AutoMat_GPS,Serial::RxIrq); // defini une interruption chaque foix que le recepteur GPS envoi un charactere
    _ComXbee.baud(38400);
    RSTXbee=0;
    wait(0.5);
    RSTXbee=1;
    Sansors_Init();
    //--------------------
    //-------------- File Creat RGPSLogX.csv and DataLogX.csv          X=FileIndex
#ifdef EN_AutoMat_DataLog  
    FileIndex = 0;
Started:
    FileIndex++;
  
    //--------------------
    sprintf(DataLogFileName,"/USB/DataLog%4lu.csv",FileIndex);
    Fs_Log = fopen(DataLogFileName, "r");//ajouter un nouveau fichier et écraser l'ancien
    if (Fs_Log!=NULL) goto Started;

    Fs_Log = fopen(DataLogFileName, "w");//ajouter un nouveau fichier et écraser l'ancien
    //-------------------- Verification de la creations des fichers
    if(Fs_Log==NULL) goto LabError;
    fprintf(Fs_Log,"LogData\r\n");
    fprintf(Fs_Log,"TIMER;GPS;Qual;Heur;LatD;LongD;HMSL;");
    fprintf(Fs_Log,"PDV;CRS;ALT;SPD;TEM\r\n");
#endif      
    //--------------------
    // Active les Automat
    ET_AutoMat_ALT = ET_01;
    ET_AutoMat_TAS = ET_01;
    ET_AutoMat_CAP = ET_01;
    ET_AutoMat_TEM = ET_01;
    ET_AutoMat_LCD = ET_01;
    _Ticker1ms.attach_us(&Irq01ms,Irq_Time_us);
    // la variable  un nom de 1ms mais on fait ca sur 5ms ce n'est pas cohérent !!!!!!!
    // Samir
    //--------------------
    CRS    = 9991;// initialisation
    ALT    = 9992;// initialisation
    SPD    = 9993;// initialisation
    TEM    = 9994;// initialisation
    Flag_Timer = 0;
    //-------------------
    TimeBtpress=0;
    while(TimeBtpress<100) { // Boutton pour pouvoir controler le debut de l'enregistrement
        if(boutonStart == 1)TimeBtpress++;
        else TimeBtpress=0;
        wait_ms(10);
    }
    //-------------------
    TimeBtpress=0;
    while(TimeBtpress<0xFFFF) {

        switch  (Flag_Timer) {

            case 0x01:// 05 ms
                Flag_Timer = 0;
                // Boutton pour pouvoir controler la fin de l'enregistrement
                if(boutonEnd == 1)TimeBtpress++;
                else TimeBtpress=0; 
                //------------------
                break;
            case 0x03:// 10 ms
                Flag_Timer = 0xFF;
                #ifdef EN_AutoMat_DataLog
                AutoMat_DataLog();
                #endif
                AutoMat_Xbee_Tx();
                Flag_Timer = 0;
                break;
            case 0x07:// 100 ms
                Flag_Timer = 0xFF;     

                GPS    = OldGPS;
                OldTIMER_10ms = TIMER_10ms;
                OldALT = ALT;
                OldSPD = SPD;
                OldCRS = CRS;
                OldTEM = TEM;
                
                HK_ALT = OldALT/10.0;
                HK_SPD = OldSPD/10.0;
                HK_CRS = OldCRS/10.0;
                
                ET_AutoMat_Xbee_Tx = ET_01;
                ET_AutoMat_DataLog = ET_01;
                
                //------------------ vérification si le Bt de fin est press pendent un Dt=100 ms
                if(TimeBtpress>100) {
                    TimeBtpress = 0xFFFF;
                    ET_AutoMat_Xbee_Tx = ET_00;
                    ET_AutoMat_DataLog = ET_00;
                }
                //------------------
                #ifdef EN_AutoMat_DataLog
                AutoMat_DataLog();
                #endif
                AutoMat_Xbee_Tx();

                Flag_Timer = 0x00;
                break;

            default:
                break;
        }// fin switch
    }// fin while
    _Ticker1ms.detach(); // ticker detach
    _ComGPS.attach(NULL,Serial::RxIrq); // detach Com GPS
    LedXbee = 0;
    LedGPS  = 0;
#ifdef EN_AutoMat_DataLog
    LedLog  = 1;
     fprintf(Fs_Log,"END\r\n");
     fclose(Fs_Log);
    wait(1);
    LedLog  = 0;
#endif
    while(1) {
        LedError=!LedError;
        wait(0.5);
    }
//----------------
#ifdef EN_AutoMat_DataLog
LabError:
    LedError=1;
#endif    
//----------------

}
