#include "mbed.h"
#include "C12832.h"
#include "MSCFileSystem.h"
//-----------------------
#include "Define.h"
#include "RecGPS.h"
//-----------------------
 MSCFileSystem fsLog("USB");    //  Enregsetement des doonées "Flash Disque USB" 
 FILE    *Fs_Log;
 I2C     _I2C(p28,p27);         //  I2C    SCL,SDA
 Serial  _ComGPS(p13, p14);     //  TX non connecté, pin14 RX.   
 Serial  _ComXbee(p9,p10);      //  Serial tx(p9),rx(10)
 #define  pRST_Xbee   p30       //  pin RST Xbee
 Ticker  _Ticker5ms;
 Timer   _Timer1;               // Timer pour mesurer le temps
 
 DigitalIn  boutonStart(p13);   // Joystique Left  : Boutton pour pouvoir controler le debut de l'enregistrement
 DigitalIn  boutonEnd(p16);     // Joystique Right : Boutton pour pouvoir controler la fin de l'enregistrement

 DigitalOut  RSTXbee (p30); 
 DigitalOut  LedGPS  (LED1); 
 DigitalOut  LedLog  (LED2);
 DigitalOut  LedXbee (LED3);
 DigitalOut  LedError(LED4);
//-----------------------
StructGPS GPS;
unsigned long TimeBtpress=0,TIMER_10ms;
unsigned long FileIndex;
char          Txt[16],Txt_Log[100],Txt_Tx2GSC[100],DataLogFileName[32];
unsigned long tk1; // des variables pour stocker les temps de mesure
//----------------------------------- Reception des données GPS  10Hz
void AutoMat_GPS(){
static unsigned char i=0,j=0,GPSDataType=0,ET_AutoMat_GPS=ET_01;
static char gps_mess;
  while(_ComGPS.readable()){
        gps_mess=_ComGPS.getc();      
 
        switch(ET_AutoMat_GPS){
           case ET_01:  if(gps_mess==prompt$GP[i]){
                            i++;
                            if(i==3){
                                i=0;
                                j=0;
                                ET_AutoMat_GPS=ET_02;                            
                            }
                        }else i=0;                        
                        break;
           case ET_02:  if(gps_mess==promptGGA[i]){
                            i++;
                            if(i==3){
                                i=0;
                                j=0;
                                ET_AutoMat_GPS = ET_03;
                                GPSDataType = GGA;                                
                               }
                            break;
                        }else i=0;
                     
                        if(gps_mess==promptRMC[j]){
                            j++;                            
                            if(j==3){
                                 j=0;
                                 ET_AutoMat_GPS=ET_03;
                                 GPSDataType=RMC;                               
                            }
                            break;
                        }else j=0;
                        
                        ET_AutoMat_GPS=ET_01;
                        break;
             
           case ET_03:  _MsgGPSRx[i]=gps_mess;
                        i++;
                        if((i<NData_GPS_Max)&&(gps_mess!=0x0D))break;
                           
                        switch(GPSDataType){
                             
                                case GGA: DecodageGPGGA(i-1);// l'appel de la fonction de decodage du message GPGGA  
                                          LedGPS=!LedGPS;
                                          if (GpsData.GGA_Valid==0x01){
                                                GpsData.GGA_Valid=0x00;                                            
                                                GPS=GpsData;                  
                                          }
                                          break;
                                case RMC: //DecodageGPRMC(i-1);// l'appel de la fonction de decodage du message GPGGA  //DecodageGPRMC(i-1);                                    
                                          break;
                                default:  break;                         
                               }
                        ET_AutoMat_GPS=ET_01;                        
                        GPSDataType=0;
           default : break;
        }
   }
}    
//----------------------------------- Transmission données au sol 10 packet/s
void AutoMat_Xbee_Tx(){
             switch  (ET_AutoMat_Xbee_Tx) { 
                    case ET_01:
                           LedXbee = !LedXbee;
                           sprintf(Txt_Tx2GSC,"$GPS;%lu;%lu;",OldTimer_10ms,GPS.Qual);                         
                           _ComXbee.printf("%s",Txt_Tx2GSC);                     
                           ET_AutoMat_Xbee_Tx = ET_02;
                           break;                  
                    case ET_02 : 
                           sprintf(Txt_Tx2GSC,"%2u:%2u:%2u;",GPS.hh,GPS.mm,GPS.ss);
                           _ComXbee.printf("%s",Txt_Tx2GSC);                           
                           ET_AutoMat_Xbee_Tx = ET_03;
                           break;
                    case ET_03 :
                           sprintf(Txt_Tx2GSC,"%2u;%2u.%u;%c;",GPS.LatDeg,GPS.LatMin,GPS.Latmmmm,GPS.LatDir);
                           _ComXbee.printf("%s",Txt_Tx2GSC);                
                           ET_AutoMat_Xbee_Tx = ET_04;
                           break;
                    case ET_04 :
                           sprintf(Txt_Tx2GSC,"%3u;%2u.%u;%c;",GPS.LongDeg,GPS.LongMin,GPS.Longmmmm,GPS.LongDir);
                           _ComXbee.printf("%s",Txt_Tx2GSC);
                           ET_AutoMat_Xbee_Tx = ET_05;                                                     
                          break;
                    case ET_05 :
                           sprintf(Txt_Tx2GSC,"%c%u\r\n",GPS.SignHMSL,GPS.HMSL);
                           _ComXbee.printf("%s",Txt_Tx2GSC);
                           ET_AutoMat_Xbee_Tx = ET_06;
                          break;
                    //------------       
                    case ET_06 :                          
                           sprintf(Txt_Tx2GSC,"$PDV;%lu;%4u;%4u;%4u;%4d\r\n",OldTimer_10ms,OldCAP,OldALT,OldTAS,OldTEMPRE);
                           _ComXbee.printf("%s",Txt_Tx2GSC);
                           ET_AutoMat_Xbee_Tx = ET_00;
                          break;                                        
                   default: ET_AutoMat_Xbee_Tx=ET_00; break;       
           }  
}
//----------------------------------- LogData 100Hz,  LogGPS 10Hz
void AutoMat_DataLog(){
        switch  (ET_AutoMat_DataLog){ 
                                           
         case ET_01:
                LedLog=!LedLog;
                //--------------
                OldTimer_10ms = TIMER_10ms;
                // au max 100us    (0.1ms)
                sprintf(Txt_Log,"PDV;%lu;%5d;%5d;%5d;%5d\r\n",TIMER_10ms,CAP,ALT,TAS,TEMPRE);           
                // au max 5000 us  (5ms)
                fprintf(Fs_Log,Txt_Log);                 
                // 100us
                sprintf(Txt_Log,"GPS;%lu;%1u;%2u:%2u:%2u;%2u;%2u.%u;%c;%3u;%2u.%u;%c;%c%u\r\n",TIMER_10ms,GPS.Qual,GPS.hh,GPS.mm,GPS.ss,GPS.LatDeg,GPS.LatMin,GPS.Latmmmm,GPS.LatDir,GPS.LongDeg,GPS.LongMin,GPS.Longmmmm,GPS.LongDir,GPS.SignHMSL,GPS.HMSL);
                // au max 5 ms
                fprintf(Fs_Log,Txt_Log);                 
                //------------------                  
                ET_AutoMat_DataLog++;                 
                break;                                
         case ET_02:
         case ET_03:
         case ET_04:
         case ET_05:
         case ET_06:                
         case ET_07:
         case ET_08:
         case ET_09:                                                    
         case ET_10: 
                // au max 100us    (0.1ms)
                sprintf(Txt_Log,"PDV;%lu;%5d;%5d;%5d;%5d\r\n",TIMER_10ms,CAP,ALT,TAS,TEMPRE);            
                // au max 5000 us  (5ms)
                fprintf(Fs_Log,Txt_Log);                                                                                          
                break;
                
         default: break ;
      }    
}
//------------------------------------------ Sansors
void AutoMat_ALT_EAGLE_V4(){      
    static char     L_i2c_Data[2],error;    
    switch (ET_AutoMat_ALT) {
        case ET_01 : 
                    L_i2c_Data[0] = 0x07; // Send "register number" command to sensor 
                    error = _I2C.write(Add_Sensor_ALT_EG4, L_i2c_Data, 1,true); // Send command string
                    if (error==0) ET_AutoMat_ALT = ET_02;                
                    break;
        case ET_02 : 
                    error = _I2C.read(Add_Sensor_ALT_EG4, L_i2c_Data, 2, true);
                    if (error==0) {
                    ALT = *((unsigned short*)L_i2c_Data)&0xffff; //altitude en décimètre
                    ALT = ALT-3000;
                    }
                    ET_AutoMat_ALT = ET_01;
                    break;
        default : break;
    }
} 

void AutoMat_TAS_EAGLE_V4(){      
    static char     L_i2c_Data[2],error;    
    switch (ET_AutoMat_TAS) {
        case ET_01 : 
                    L_i2c_Data[0] = 0x07; // Send "register number" command to sensor 
                    error = _I2C.write(Add_Sensor_TAS_EG4, L_i2c_Data, 1,true); // Send command string
                    if (error==0) ET_AutoMat_TAS = ET_02;                
                    break;
        case ET_02 : 
                    error = _I2C.read(Add_Sensor_TAS_EG4, L_i2c_Data, 2, true);
                    if (error==0) {
                    TAS = *((unsigned short*)L_i2c_Data)&0xffff; //altitude en décimètre
                    TAS = sqrt((float)(TAS-offset_TAS)*5.87755102);
                    }
                    ET_AutoMat_TAS = ET_01;
                    break;
        default : break;
    }
} 
void AutoMat_CAP_HMC(){      
    static char     L_i2c_Data[2],error;    
    switch (ET_AutoMat_CAP) {
        case ET_01 : 
                    L_i2c_Data[0] = 0x07; // Send "register number" command to sensor 
                    error = _I2C.write(Add_Sensor_CAP_HMC, L_i2c_Data, 1,true); // Send command string
                    if (error==0) ET_AutoMat_CAP = ET_02;                
                    break;
        case ET_02 : 
                    error = _I2C.read(Add_Sensor_CAP_HMC , L_i2c_Data, 2, true);
                    if (error==0) {
                    CAP = *((unsigned short*)L_i2c_Data)&0xffff; //altitude en décimètre                    
                    }
                    ET_AutoMat_CAP = ET_01;
                    break;
        default : break;
    }
} 
//------------------- 
void Sansors_Init(){ 
    char  L_i2c_Data[3];        
     //------------ init Compass HMC //Continuous mode, periodic set/reset, 20Hz measurement rate.
     L_i2c_Data[0] = HMC6352_CONTINUOUS;
     L_i2c_Data[1] = 0x01;
     L_i2c_Data[2] = 20;  
     _I2C.write(Add_Sensor_CAP_HMC,L_i2c_Data,3); // Send command          
     //----------------------------
     wait_ms(1);         //attendre 1mS 
     //------------- Get Offset TAS
     L_i2c_Data[0] = 0x01; // Send "read data" command to sensor 
     _I2C.write(Add_Sensor_TAS_EG4,L_i2c_Data,1); // Send command string
     wait_ms(1);         //attendre 400µS avant de relancer
     _I2C.read(Add_Sensor_TAS_EG4,L_i2c_Data, 2);
     offset_TAS = *((unsigned short*)L_i2c_Data)&0xffff; // Altitude en décimètre      
}

void Irq05ms(){
static unsigned char L_Flag_Timer=0, LTIMER005ms=0,LTIMER010ms=0;
     LTIMER005ms++;       
     L_Flag_Timer  = 1;
     //-----------------------------
     if(LTIMER005ms >= 2){
          //-----------------                  
          TIMER_10ms  = TIMER_10ms+1;
          LTIMER005ms = 0;          
          LTIMER010ms++;
          L_Flag_Timer  = 2;
          //-----------------
          if(LTIMER010ms >= 10){
               LTIMER010ms   = 0;
               L_Flag_Timer  = 3;                           
          }
          //-----------------
     }
     
     AutoMat_ALT_EAGLE_V4();
     AutoMat_TAS_EAGLE_V4();
     AutoMat_CAP_HMC();
                
     if (Flag_Timer != 0xFF) Flag_Timer = L_Flag_Timer;
     //-----------------------------
 }
     
int main() {
    
     CAP = 0;
     TAS = 0;
     ALT = 0;
     LedError = 0;           
     //-------------------- 
     _I2C.frequency(100000);             
     _ComGPS.baud(38400); //GPS V4 EAGLE
     _ComGPS.attach(&AutoMat_GPS,Serial::RxIrq); // defini une interruption chaque foix que le recepteur GPS envoi un charactere   
     _ComXbee.baud(38400); 
     RSTXbee=0;
     wait(0.5);
     RSTXbee=1;          
     Sansors_Init();
     //--------------------
     //-------------- File Creat RGPSLogX.csv and DataLogX.csv          X=FileIndex
     FileIndex = 5;
     //--------------------
     sprintf(DataLogFileName,"/USB/DataLog%lu.csv",FileIndex);
     Fs_Log = fopen(DataLogFileName, "w");//ajouter un nouveau fichier et écraser l'ancien     
     //-------------------- Verification de la creations des fichers 
     if(Fs_Log==NULL) goto LabError;     
     fprintf(Fs_Log,"LogData\r\n");    
     fprintf(Fs_Log,"GPS;TIMER1;Qual;Heur;LatD;LatMin;LatDir;LongD;LongMin;LongDir;HMSL\r\n"); 
     fprintf(Fs_Log,"PDV;TIMER1;CAP;ALT;TAS;Tem\r\n");      
     //--------------------
     // Active les Automat
     ET_AutoMat_ALT = ET_01;
     ET_AutoMat_TAS = ET_01;
     ET_AutoMat_CAP = ET_01;
     _Ticker5ms.attach_us(&Irq05ms,5000);   
     // la variable  un nom de 1ms mais on fait ca sur 5ms ce n'est pas cohérent !!!!!!!
     // Samir
     //--------------------
     CAP    = 9991;
     ALT    = 9992;
     TAS    = 9993;
     TEMPRE = 9994;   
     TimeBtpress=0;  
     while(TimeBtpress<100){
        if(boutonStart == 1)TimeBtpress++;
        if(boutonStart == 0)TimeBtpress=0; 
        wait(0.005);
     }    
     //while(boutonStart==0); // Boutton pour pouvoir controler le debut de l'enregistrement
     Flag_Timer = 0;
     TimeBtpress=0; 
     while(boutonEnd==0){   // Boutton pour pouvoir controler la fin de l'enregistrement
       
       switch  (Flag_Timer) {                                     

         case 0x01:
                Flag_Timer = 0;
                break;
         case 0x02:               
                Flag_Timer = 0xFF;              
                AutoMat_DataLog(); 
                AutoMat_Xbee_Tx();
                
                Flag_Timer = 0;
                break;
         case 0x03:
                Flag_Timer = 0xFF;             
         
                GPS    = GpsData;
                OldALT = ALT;
                OldTAS = TAS;
                OldCAP = CAP;
                OldTEMPRE = TEMPRE;
                
                ET_AutoMat_Xbee_Tx = ET_01; 
                ET_AutoMat_DataLog = ET_01;                  
                AutoMat_DataLog();
                AutoMat_Xbee_Tx();       
    
                Flag_Timer = 0x00;
                break;
                                
         default: break;    
        }// fin switch 
      } 
      _Ticker5ms.detach(); 
      _ComGPS.attach(NULL,Serial::RxIrq);
      LedXbee = 0;
      LedGPS  = 0;      
      LedLog  = 1;
      fclose(Fs_Log);
      wait(1);
      LedLog  = 0;       
      while(1){
        LedError=!LedError;
        wait(0.5);
      }   
//----------------
LabError:    
    LedError=1;
//----------------

}
