#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "platform/mbed_thread.h"            
#define SCREEN_ADRESS 0x3D
 
DigitalOut myled(LED1);
static BufferedSerial pc(USBTX, USBRX);         //pc Seriel für baud

using namespace std::chrono;                    //Namespce für printf



// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        //start();
    };
};

 
I2CPreInit gI2C(I2C_SDA, I2C_SCL);
Adafruit_SSD1306_I2c gOled2(gI2C,D4,0x7A,64,128);           //D4: Adresse für reset, 0x7A: I2C Adresse
 
int main()
{   uint16_t i=0;
    thread_sleep_for(1000);
    pc.set_baud(9600);                                  //baudrate
    gOled2.clearDisplay();
    gOled2.drawPixel (10, 10,WHITE);
    gOled2.display();
    thread_sleep_for(1000);
    gOled2.clearDisplay();
    while(true)
    {
        gOled2.setTextCursor(0,0);
        gOled2.printf("%ux%u OLED Display\r\n", gOled2.width(), gOled2.height());
        gOled2.printf("Hello World\n");
        gOled2.printf("Laufnr.: %d\r",i);
        gOled2.display();
        i++;
        myled = !myled;
        thread_sleep_for(1000);
        gOled2.clearDisplay();
    }
}