#############################################################################################################
Shadow Demo Summary
#############################################################################################################
The Shadow demo uses the FRDM-K64F target hardware and the Avnet Shield M14A2A (using AT&T LTE network) to 
connect to an Amazon Web Services IoT "thing" (device).  The AWS IoT device Shadow will reflect the FRDM LED 
color along with FRDM sensor data.  The Python GUI (ATT_AWS_IoT_Demo_GUI.py) can be used to reflect the Shadow 
information and request LED color changes.

#############################################################################################################
Topic Demo Summary
#############################################################################################################
The Topic demo can be ran by following the steps in the "Topic Demo Quickstart" below.  Instead of writing to
the thing Shadow this demo publishes a JSON payload (color/temp/humidity) to a Topic.  From AWS you can define
a Rule to perform any number of actions from the Topic.

#############################################################################################################
Resources
#############################################################################################################
Getting Started with MBED using FRDM-K64F: (NOTE!!! The FRDM bootloader MUST be updated to work with Windows 10)
https://developer.mbed.org/platforms/frdm-k64f/

Avnet IoT Kit quickstart:
https://starterkit.att.com/quickstart

AWS IoT Interactive Tutorial (what this demo is based on):
https://us-west-2.console.aws.amazon.com/iot/home?region=us-west-2#/tutorial/help

AWS IoT C-SDK Tutorial (targeted for Raspberry Pi-2):
http://docs.aws.amazon.com/iot/latest/developerguide/iot-device-sdk-c.html

Python AWS IoT Tutorial:
https://github.com/aws/aws-iot-device-sdk-python

#############################################################################################################
Shadow Demo Quickstart
#############################################################################################################
NOTE1: FRDM-K64F bootloader must be updated to work with Windows 10 (otherwise board will reset over and over).

FRDM-K64F:
1) This quickstart assumes you've gone through the "Getting Started with MBED using FRDM-K64F" and that you
   can successfully drag-and-drop binaries to flash the FRDM-K64F device.


AT&T IoT Kit:
1) This quickstart assumes you've gone through the "Avnet IoT Kit quickstart" and your kits sim card has been
   activated and verified to work with the AT&T LTE network.


Amazon AWS IoT:
1) Create an AWS IoT thing using AWS IoT Console.  Makes sure to get your 'thing' certificates.


MBED:
1) In the mbed ATT_AWS_IoT_demo project open "network_interface.h" and comment in the following:
   #define USING_AVNET_SHIELD 

   NOTE: Make sure you only comment in ONE Network Connection.  Alternately you can comment in
   USING_FRDM_K64F_LWIP to use the wired Ethernet.


2a) Option a (default) - Use an SD card:
    a) Format a MicroSD card to use a "FAT32" file system (https://www.sdcard.org/downloads/formatter_4/)

    b) Create a folder on the SD card root named 'certs'

    c) Copy your AWS things certs into this folder.  Your file paths should look exactly like this:
    /certs/rootCA-certificate.crt
    /certs/certificate.pem.crt
    /certs/private.pem.key

    d) Create a file in the 'certs' directory named 'mqtt_config.txt', and copy the template below into the file
       fill in these parameters with your AWS IoT thing information (minus the brackets):
       NOTE: Port is always 8883 (if not using web socket)
AWS_IOT_MQTT_HOST=[1234asdf.iot.us-west-2.amazonaws.com]
AWS_IOT_MQTT_PORT=8883
AWS_IOT_MQTT_CLIENT_ID=[MyThingName]
AWS_IOT_MY_THING_NAME=[MyThingName]

    e) Place SD card into the FRDM-K64F MicroSD slot before powering it on.


2b) Option b - Hard code certs/key and MQTT config:
    a) In the mbed ATT_AWS_IoT_demo project open "aws_iot_config.h" and comment out the following #define:
    //#define USING_SD_CARD

    b) In the mbed ATT_AWS_IoT_demo project open "aws_iot_config.h" and update the following to match your AWS 
       IoT 'thing':
    #define AWS_IOT_MQTT_HOST
    #define AWS_IOT_MQTT_CLIENT_ID
    #define AWS_IOT_MY_THING_NAME

    c) In the mbed ATT_AWS_IoT_demo project open "certs.cpp" and update the following to match your AWS 'thing' 
       private key and IoT certificate. NOTE Make sure the string format matches the format of AWS_IOT_ROOT_CA 
       (which is pre-populated):
    const unsigned char AWS_IOT_CERTIFICATE[]
    const unsigned char AWS_IOT_PRIVATE_KEY[]


Python GUI (optional):
1) The Python GUI "ATT_AWS_IoT_Demo_GUI.py" is used to communicate with the 'thing' device shadow, and can
   be used to request 'desired' and report 'reported' shadow states.  This quickstart assumes you've gone 
   through the "Python AWS IoT Tutorial" to the point where you've installed Python 2.7.11 and the libraries
   required to run the script (paho-mqtt, AWSIoTPythonSDK).

2) Copy the mbed project folder "PythonGUI" onto your PC somewhere. "C:/Temp/PythonGUI" for example.

3a) Option a (default) - Use an mqtt_config.txt file:
   a) Use the same mqtt_config.txt file from MBED section above.
   b) Place the file where Python looks for it:
   AWS_MQTT_CONFIG_FILENAME     = "C:/Temp/certs/mqtt_config.txt"

3b) Option b - Hard code the MQTT config:
   a) In the ATT_AWS_IoT_Demo_GUI.py script search for the "AWS IoT Config Parameters" and update them so they
      match the same 'thing' parameters as the mbed project.

   b) In the Python file change the following variable to TRUE:
   hardCodeMQTT = True

4) Place your 'thing' certificates into file locations where the Python looks for them.  For example:
   AWS_IOT_ROOT_CA_FILENAME     = "C:/Temp/certs/rootCA-certificate.crt"
   AWS_IOT_PRIVATE_KEY_FILENAME = "C:/Temp/certs/private.pem.key"
   AWS_IOT_CERTIFICATE_FILENAME = "C:/Temp/certs/certificate.pem.crt"
   
Once all this is setup you should be able to:
1) See the FRDM board start up and connect to Amazon and then create a 'thing' shadow (if there is none).
2) See the FRDM board get the shadow LED color.
3) Press the SW3 button on the FRDM board to cycle the LED color ->              (Off R G B W)
4) Use the AWS IoT Console to "Update shadow" to set new 'desired' colors via -> (0   1 2 4 7)
5) Use the Python GUI buttons to request 'desired' colors.  The GUI should also report the "AWS Reported LED Status"
6) See the FRDM board report the Temperature and Humidity values.

#############################################################################################################
Topic Demo Quickstart
#############################################################################################################
1) In order to setup the Topic Demo you still have to perform all of the Shadow Demo steps.

2) In the mbed ATT_AWS_IoT_demo project open "main.cpp" and comment in the following line:
   //return outOfBoxDemo();

3) In the mbed ATT_AWS_IoT_demo project open "aws_iot_config.h" and set the AWS_IOT_MY_TOPIC:
   #define AWS_IOT_MY_TOPIC               "ExampleTopic/%s"

4) In AWS Console go to AWS IoT -> Test -> Subscribe to a topic and as the topic name put in "ExampleTopic/+"
   // NOTE: the "/+" is a wildcard, this demo puts the ICCID there.  This allows you to have multiple devices
   // publish to the same Topic.

Once all this is setup you should be able to:
Wait for the target to print "READY TO PUBLISH!"
Press the SW3 button, and the LED should change color and a JSON packet will be sent to the Topic
In the AWS Console you should see the Topic data, for example -> "{"color":"Blue","temperature":86.876564,"humidity":36}"