#include "mbed.h"

/**
 * GPIO toggle test on ST Nucleo F411RE
 *
 * Resuts:
 * 1. DigitalOut            4.46MHz, 11210msec
 * 2. BSRRL/BSRRH register  20.8MHz,  2402msec
 * 3. bit banding           15.6MHz,  3203msec
 *
 * @author masuda, Masuda Naika
 */

#define BITBAND_PERIPH(addr, bit) \
    (volatile uint32_t*)(PERIPH_BB_BASE+((uint32_t)addr-PERIPH_BASE)*32+(bit*4))
    
#define LOOP_COUNT 10000000

PinName pinName = D10;
DigitalOut dout(pinName, 0);
Timer t;
Serial pc(SERIAL_TX, SERIAL_RX);

GPIO_TypeDef *gpio_port_reg;
volatile uint32_t gpio_reg_set_mask;
volatile uint32_t gpio_reg_reset_mask;
volatile uint32_t *bb_gpio_port;

void digitalOutTest();
void bsrrTest();
void bitbandTest();


int main() {
    
    //set gpio port addresses and masks
    uint32_t port_index = (uint32_t) pinName >> 4;
    gpio_port_reg = (GPIO_TypeDef *) (GPIOA_BASE + (port_index << 10));
    gpio_reg_set_mask = 1 << ((uint32_t) pinName & 0xf);
    gpio_reg_reset_mask = gpio_reg_set_mask << 16;

    // set bit band addresses
    uint8_t port_bit = (uint32_t) pinName & 0xf;
    bb_gpio_port = BITBAND_PERIPH(&gpio_port_reg->ODR, port_bit);
    
    dout = 0;
    wait_ms(2000);
    t.start();
    
    while(true) {
        digitalOutTest();
        bsrrTest();
        bitbandTest();
    }
}

void digitalOutTest() {
    
    uint32_t l = LOOP_COUNT;
    int t1 = t.read_ms();
    
    while(l--) {
        dout = 1;
        dout = 0;
        dout = 1;
        dout = 0;
        dout = 1;
        dout = 0;
        dout = 1;
        dout = 0;
        dout = 1;
        dout = 0;
    }
    
    int t2 = t.read_ms();
    pc.printf("DigitalOut: %d msec\n", t2 - t1);
    wait_ms(1000);
}

void bsrrTest() {
    
    uint32_t l = LOOP_COUNT;
    int t1 = t.read_ms();

//    __asm("ALIGN 4");
    while(l--) {
        gpio_port_reg->BSRR = gpio_reg_set_mask;
        gpio_port_reg->BSRR = gpio_reg_reset_mask;
        gpio_port_reg->BSRR = gpio_reg_set_mask;
        gpio_port_reg->BSRR = gpio_reg_reset_mask;
        gpio_port_reg->BSRR = gpio_reg_set_mask;
        gpio_port_reg->BSRR = gpio_reg_reset_mask;
        gpio_port_reg->BSRR = gpio_reg_set_mask;
        gpio_port_reg->BSRR = gpio_reg_reset_mask;
        gpio_port_reg->BSRR = gpio_reg_set_mask;
        gpio_port_reg->BSRR = gpio_reg_reset_mask;
    }
    
    int t2 = t.read_ms();
    pc.printf("BSRR: %d msec\n", t2 - t1);
    wait_ms(1000);
}

void bitbandTest() {

    uint32_t l = LOOP_COUNT;
    int t1 = t.read_ms();
    
//    __asm(".align 4");
    while(l--) {
        *bb_gpio_port = 1;
        *bb_gpio_port = 0;
        *bb_gpio_port = 1;
        *bb_gpio_port = 0;
        *bb_gpio_port = 1;
        *bb_gpio_port = 0;
        *bb_gpio_port = 1;
        *bb_gpio_port = 0;
        *bb_gpio_port = 1;
        *bb_gpio_port = 0;
    }
    
    int t2 = t.read_ms();
    pc.printf("Bit band: %d msec\n", t2 - t1);
    wait_ms(1000);
}
