#include "stm32f1xx_ll_bus.h"
#include "stm32f1xx_ll_gpio.h"
#include "stm32f1xx_ll_dma.h"
#include "stm32f1xx_ll_spi.h"
#include "stm32f1xx_ll_cortex.h"

//#include "stm32f1xx_ll_rcc.h"
//#include "stm32f1xx_ll_system.h"
//#include "stm32f1xx_ll_utils.h"


/**
 * STM32F103C8T6 Blue Pill
 *
 * Software Digital audio Transmitter
 *  for Roland SC-88pro (32kHz, 18bit, Right justified, 256fs)
 *
 * @author masuda, Masuda Naika
 */

// channel status consumer
// byte0
#define C_PRO       0
#define C_AUDIO     1
#define C_COPY      2
#define C_EMPH0     3
#define C_EMPH1     4
#define C_EMPH2     5
#define C_MODE0     6
#define C_MODE1     7

// byte3
#define C_FS0       0
#define C_FS1       1
#define C_FS2       2
#define C_FS3       3
#define C_CLKACC0   4
#define C_CLKACC1   5

#define _BV(bit)    (1 << (bit))

// SPDIF preambles, last cell zero, stretched double to 16bit
#define PREAMBLE_Z  0b1111110011000000 //0b11101000
#define PREAMBLE_X  0b1111110000001100 //0b11100010
#define PREAMBLE_Y  0b1111110000110000 //0b11100100

// Biphase Mark Code table
volatile const uint16_t bmcTable[16] = {
    0b1111000011110000,
    0b1100111100001111,
    0b1111001100001111,
    0b1100110011110000,
    0b1111000011001111,
    0b1100111100110000,
    0b1111001100110000,
    0b1100110011001111,
    0b1111000011110011,
    0b1100111100001100,
    0b1111001100001100,
    0b1100110011110011,
    0b1111000011001100,
    0b1100111100110011,
    0b1111001100110011,
    0b1100110011001100,
};

// SPIRx-DMA circular buffer
typedef struct {
    uint16_t ltCh[8];
    uint16_t rtCh[8];
} SpiRxBuff;

// SPITx-DMA circular buffer
typedef struct {
    uint16_t aCh[8];
    uint16_t bCh[8];
} SpiTxBuff;

// channel status
typedef struct {
    uint8_t ltCh;
    uint8_t rtCh;
} ChannelStatus;

// Private function prototypes
uint8_t calcCRC(uint8_t *chStatusPtr);
uint32_t oddParity(uint32_t val);
void setChannelStatus();
void setupPeripherals();
void transferFrames();
void transferFrame();
void transferSubFrame(uint32_t frameIndex, bool aCh, uint16_t *rxBuffPtr, uint16_t *txBuffPtr);
void toBinary(uint16_t *val_ptr, char *str);
void debugOut();
void SystemClock_Config();

// for 72MHz
//extern "C" uint8_t SetSysClock_PLL_HSE(uint8_t bypass); // in "system_clock.c"
