#ifndef RN52_H
#define RN52_H


typedef enum
{
    RN52_LIMBO,
    RN52_CONNECTABLE,
    RN52_CONNECTABLE_DISCOVERABLE,
    RN52_CONNECTED,
    RN52_OUTGOING_CALL,
    RN52_INCOMING_CALL,
    RN52_ACTIVE_CALL,
    RN52_TEST_MODE,
    RN52_THREE_WAY_CALL_WAITING,
    RN52_THREE_WAY_CALL_ON_HOLD,
    RN52_THREE_WAY_CALL_MULTI_CALL,
    RN52_INCOMING_CALL_ON_HOLD,
    RN52_ACTIVE_CALL2,
    RN52_AUDIO_STREAMING,
    RN52_LOW_BATTERY,
    RN52_NOT_SET,

    RN52_CONNECTION_LAST
  
} RN52_CONNECTION;


typedef enum
{
    RN52_NO_EVENT,
    RN52_CALLER_ID_EVENT,
    RN52_TRACK_CHANGE_EVENT,
    RN52_OTHER_EVENT,

    RN52_EVENT_LAST
  
} RN52_EVENT;

typedef struct
{
    RN52_EVENT event;
    bool media_connected;
    bool phone_connected;
    RN52_CONNECTION connection;
    char title[255];
    char artist[255];
    char album[255];
    char genre[255];
    int duration;
    int track_number;
    int track_count;
    char response[255];
    
} RN52_RESULT;




//----------------------------------------------------------------------------
// CLASS
//----------------------------------------------------------------------------

class RN52
{
public:
    void init();
    void enable();
    void disable();
    bool check_event(RN52_RESULT * rn52_result);
    bool connect();
    bool disconnect();
    bool next_track();
    bool prev_track();
    bool toggle_play();
    bool maxvolume();
    bool get_status(RN52_RESULT * result);
    bool get_caller_id(RN52_RESULT * result);
    bool get_track_metadata(RN52_RESULT * result);
    bool capture_response(char * str);
    void clear_serial();
    void copy_response(char * source, char * destination, char offset);      
    void clear_result(RN52_RESULT * result);
    void config(char * name);
};

#endif