

#ifndef CDC_H
#define CDC_H

#include "mbed.h"

typedef enum
{
  IBUS_NO_MESSAGE,
  IBUS_OTHER_MESSAGE,
  IBUS_CDC_ON,
  IBUS_CDC_OFF,
  IBUS_NEXT,
  IBUS_VOLUME_UP,
  IBUS_VOLUME_DOWN,
  IBUS_SKIP_FW,
  IBUS_SKIP_BW,
  IBUS_SET,
  IBUS_CLEAR,
  IBUS_HEAD_UNIT_OFF,
  IBUS_HEAD_UNIT_ON,
  
  IBUS_COMMAND_LAST
  
} IBUS_COMMAND;

//----------------------------------------------------------------------------
// CLASS
//----------------------------------------------------------------------------

class CDC
{
public:
    void enable();
    void disable();
    void init();
    IBUS_COMMAND get_cmd();
    IBUS_COMMAND get_ihu_cmd();
    IBUS_COMMAND get_steering_wheel_cmd();
    void display(char text[]);
    void display_update();
    void update_elapsed_time();
    void reset_elapsed_time();
    void start_elapsed_time();
    void stop_elapsed_time();
    void set_track(char track_number);
    void send_can_frame(int message_id, int *msg);
    void print_can_frame(CANMessage *msg);
    void CAN_wrFilter(uint32_t ctrl, uint32_t id);
};

#endif