#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;

DigitalOut led1(LED1);

int main()
{  
    uint16_t Xrucka, Yrucka;
    double Uhelrucka, Delkarucka=75.0;    
    led1 = 1;
  
    BSP_LCD_SetFont(&Font20);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"PRPEEZ", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"L410 GAUGE", CENTER_MODE);
    wait(3);
  
    while(1)
    {      
      lcd.Clear(LCD_COLOR_BLUE);
      lcd.SetBackColor(LCD_COLOR_BLUE);
      lcd.SetTextColor(LCD_COLOR_BLACK);
      
      lcd.SetTextColor(LCD_COLOR_BLACK);
      lcd.FillCircle(120, 160, 113);
      lcd.SetTextColor(LCD_COLOR_GRAY);
      lcd.FillCircle(120, 160, 110);
      
      lcd.SetTextColor(LCD_COLOR_GREEN);
      lcd.FillCircle(51, 235, 3);
      lcd.FillCircle(26, 198, 3);
      lcd.FillCircle(19, 155, 3);
      lcd.FillCircle(30, 113, 3);
      lcd.FillCircle(56, 79, 3);
      lcd.FillCircle(98, 61, 3);
      
      lcd.SetTextColor(LCD_COLOR_YELLOW);
      lcd.FillCircle(142, 61, 3);
      lcd.FillCircle(182, 80, 3);
      
      lcd.SetTextColor(LCD_COLOR_RED);
      lcd.FillCircle(210, 113, 3);
      lcd.FillCircle(221, 156, 3);
      lcd.FillCircle(214, 199, 3);
      lcd.FillCircle(188, 235, 3);
      
      //wait(2);
      
      lcd.SetBackColor(LCD_COLOR_GRAY);
      lcd.SetTextColor(LCD_COLOR_BLACK);
      
      
      BSP_LCD_SetFont(&Font16);
      lcd.DisplayStringAt(95, 183, (uint8_t *)"CABIN", LEFT_MODE);
      lcd.DisplayStringAt(75, 200, (uint8_t *)"ALTITUDE", LEFT_MODE);
      
      BSP_LCD_SetFont(&Font16);
      lcd.DisplayStringAt(58, 227, (uint8_t *)"0", LEFT_MODE);
      lcd.DisplayStringAt(32, 190, (uint8_t *)"15", LEFT_MODE);
      lcd.DisplayStringAt(30, 155, (uint8_t *)"30", LEFT_MODE);
      lcd.DisplayStringAt(32, 117, (uint8_t *)"45", LEFT_MODE);
      lcd.DisplayStringAt(50, 89,  (uint8_t *)"60", LEFT_MODE);
      lcd.DisplayStringAt(75, 73,  (uint8_t *)"75", LEFT_MODE);
      lcd.DisplayStringAt(125, 73, (uint8_t *)"90", LEFT_MODE);
      lcd.DisplayStringAt(150, 91, (uint8_t *)"105", LEFT_MODE);
      
      lcd.SetTextColor(LCD_COLOR_RED);
      lcd.DisplayStringAt(182, 122,  (uint8_t *)"120", LEFT_MODE);
      lcd.DisplayStringAt(185, 161,  (uint8_t *)"135", LEFT_MODE);
      lcd.DisplayStringAt(172, 193, (uint8_t *)"150", LEFT_MODE);
      lcd.DisplayStringAt(148, 225, (uint8_t *)"175", LEFT_MODE);
      
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.FillCircle(120, 160, 8);
      for (Uhelrucka = 2.74; Uhelrucka < 6.90; Uhelrucka += 0.01)
        {lcd.SetTextColor(LCD_COLOR_WHITE);
         Xrucka = 120.0 + Delkarucka * cos(Uhelrucka);
         Yrucka=160.0 + Delkarucka * sin(Uhelrucka);
         lcd.DrawLine(120, 160, Xrucka, Yrucka);
         wait(0.01);   
         lcd.SetTextColor(LCD_COLOR_GRAY);
         lcd.DrawLine(120, 160, Xrucka, Yrucka);
         lcd.SetTextColor(LCD_COLOR_WHITE);
         lcd.FillCircle(120, 160, 8);
         if (Uhelrucka>5.10) 
         {
            lcd.SetTextColor(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_YELLOW);    
            BSP_LCD_SetFont(&Font24);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"WARNING", CENTER_MODE);
            BSP_LCD_SetFont(&Font16);
            lcd.DisplayStringAt(0, LINE(18), (uint8_t *)"EXCESSIVE ALTITUDE", CENTER_MODE);
         }
         
        };    
      lcd.SetTextColor(LCD_COLOR_WHITE);
      lcd.DrawLine(120, 160, Xrucka, Yrucka);
      
      
      wait(5);

      led1 = !led1;
      wait(0.5);
    }
}

