#include "mbed.h"
#include "nRF24L01P.h"
#include "menu.h"

extern bool tx_mode;    //Global variable for TX/RX mode setting
extern bool keyboard_mode;  //Global variable for keyboard mode setting
extern uint8_t interval;    //Global variable for time interval setting

Serial pc2(USBTX, USBRX); // tx, rx
nRF24L01P nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);    // mosi, miso, sck, csn, ce, irq


void settings() {
    uint16_t frequency;
    char input[]= "";
    char *ptr;
    
    pc2.printf("***Experimental 2.4 GHz Radio Link. Setup below: ***\n\n");
    
    pc2.printf("Select TX or RX Mode. TX calculates BER (only in automatic mode) and ACKs,\n RX shows number of incoming packets.:\n");
    pc2.printf("1: TX\n2: RX\n");
    //Select TX or RX mode
    switch (pc2.getc()) {
    case '1':
        tx_mode = true;
    break;
    case '2':
        tx_mode = false;
    break;
    default:
        tx_mode = true;
        pc2.printf("Wrong number! Default TX Mode was set");
        wait_ms(1000);
    break;
    }
    //Clear the console window
    pc2.puts("\e[2J\e[H");
    
    pc2.printf("Select Input. If automatic is set, the message is transmitted repeatedly\n in short intervals.:\n");
    pc2.printf("1: Keyboard\n2: Automatic\n");
    //Select keyboard input or automatic mode, if automatic mode is set and the device is in TX mode, select time interval
    switch (pc2.getc()) {
    case '1':
        keyboard_mode = true;
    break;
    case '2':
        keyboard_mode = false;
        if (tx_mode) {
            pc2.puts("\e[2J\e[H");
            pc2.printf("Please specify a time interval. The interval must be an integer number:\n");
            interval = pc2.getc() - '0';
        }
    break;
    default:
        keyboard_mode = true;
        pc2.printf("Wrong number! Default Automatic mode was set");
        wait_ms(1000);
    break;
    }
    //Clear the console window
    pc2.puts("\e[2J\e[H");
    
    pc2.printf("Type in the RF channel depending on the speed in the range of 2400 - 2525.\n The channel must be the same for RX and TX!: \n");
    //Type the number of desired RF channel in range
    pc2.gets(input, 5);
    frequency = (int) strtol(input, &ptr, 10);
    pc2.printf("Selected frequency: %d\n", frequency);
    if (frequency >= 2400 && frequency <=2525) {
        nrf24l01p.setRfFrequency(frequency);
    }
    //If wrong number was set, default frequency will be set
    else {
        pc2.printf("Wrong frequency! Default frequency was set (2402 MHz)\n");
    }
    //Clear the console window
    pc2.puts("\e[2J\e[H");
    
    pc2.printf("Select radio output power:\n");
    pc2.printf("1: 0 dB\n2: -6 dB\n3: -12 dB\n4: -18 dB\n");
    //Select the RF output power
    switch (pc2.getc()) {
    case '1':
        nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_ZERO_DB);
    break;
    case '2':
        nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_6_DB);
    break;
    case '3':
        nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_12_DB);
    break;
    case '4':
        nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_18_DB);
    break;
    default:
        pc2.printf("Wrong number! Default value was set (0 dB)\n");
        wait_ms(1000);
    break;
    }
    //Clear the console window
    pc2.puts("\e[2J\e[H");
    
    pc2.printf("Set air data rate. The air data rate must be the same for RX and TX!:\n");
    pc2.printf("1: 250 KBps\n2: 1 MBps\n3: 2 MBps\n");
    //Set the air data rate
    switch (pc2.getc()) {
    case '1':
        nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_250_KBPS);
    break;
    case '2':
        nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);
    break;
    case '3':
        nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_2_MBPS);
    break;
    default:
        pc2.printf("Wrong number! Default value was set (1 MBps)\n");
        wait_ms(1000);
    break;
    }
    //Clear the console window
    pc2.puts("\e[2J\e[H");
}
    
    
    
