#include "mbed.h"
#include "EADOG.h"
#include "Small_7.h"
#include "pwm.h"
#include "Fonts/ArialR12x14.h"
#include "wifiesp8266.h"
#include "Sht31.h"

EADOG lcd(PC_12, PC_10, PA_1, PA_0, PA_4, DOGM128); // MOSI, SCL, Reset, A0, CS
Sht31 capt(PB_9,PB_8);
InterruptIn helice(PD_2);
InterruptIn VoieA(PB_13); //interuption de la voie A port P
DigitalIn VoieB(PA_10);  //InterruptIn VoieB(PA_10);
WifiEsp8266 Wifi(PA_11,PA_12); // WifiEsp8266(PinName Txd, PinName Rxd);
DigitalOut Led(LED1);

float VitesseAir = 0; //initialisation de la VitesseAir
float Frequencehelice = 0;
int Temperature = 0;
int Humidite = 0;
unsigned char ConsVitFluxAir =0;
float FrequenceCalc = 0;
bool NewFrequence = false;

// mesure frequence helice
Timer timer;
void MesPeriode(void)
{
    Led= 1;
    FrequenceCalc = timer.read();
    timer.reset();
    FrequenceCalc = 1.0/FrequenceCalc/2.0;
    NewFrequence = true;
    Led=0;
}

// codeur
bool BoutonChange;
unsigned char inc100(unsigned char _i)
{
    if (_i<100) {
        _i++;
        BoutonChange = true;
    }
    return _i;
}
unsigned char dec0(unsigned char _i)
{
    if (_i>0) {
        _i--;
        BoutonChange = true;
    }
    return _i;
}
void FrontMontantA(void)
{
    if (VoieB.read()==0) ConsVitFluxAir=inc100(ConsVitFluxAir);
    else ConsVitFluxAir=dec0(ConsVitFluxAir);
}
void FrontDescA(void)     //fond descene
{
    if(VoieB.read()==1) ConsVitFluxAir=inc100(ConsVitFluxAir);   //jai rmplacé 0''
    else ConsVitFluxAir=dec0(ConsVitFluxAir);
}

// pour acquisition entree.
bool acquerir = false;
Ticker TickerAcq;
void TraitAcq(void)
{
    acquerir = true;
}
//drapeau pour indiquer nouvel affichage
bool affichage = false;
int main()
{
    Serial PC(USBTX,USBRX);
    PC.baud(Baud);
    PC.printf("SP1 start\r\n");
    AnalogIn EntVitesseAir(PC_5); //pour faire varier VitesseAir
    char WifiPhrase[maxdata];
    Led =1;
    // mesure frequence helice
    timer.reset();
    timer.start();
    // moteur pwm
    InitPwmMot(); // initilise PWM : voir lib T = 20ms, Largeur Imp 1ms

    // codeur
    ConsVitFluxAir = 0;
    BoutonChange = true;
    VoieA.fall(&FrontDescA); //frond descendant
    VoieA.rise(&FrontMontantA); //frond montant

// ticker acquisition toutes les secondes
    lcd.locate(0,1);
    lcd.printf("Cons Vit Air");//on affiche la consigne
    lcd.locate(0,14);
    lcd.printf("Vitesse");//on affiche la vitesse
    lcd.locate(0,27);
    lcd.printf("Temperature");//on affiche la température
    lcd.locate(0,40);
    lcd.printf("Humidite");//on affiche l'humidité
    lcd.locate(0,53);
    lcd.printf("Freq. Helice");//on afiche la fréquence d'helice
    helice.rise(&MesPeriode);
    TickerAcq.attach(&TraitAcq,0.1); // ticker toutes les secondes pour lire vitesse flux air
    while (true) {
        // wifi
        if (Wifi.dataready()) {
            strcpy(WifiPhrase,Wifi.read());
            PC.printf("%s\r\n",WifiPhrase); // pour phase de test
            switch (WifiPhrase[1]) {
                case 'F':
                    ConsVitFluxAir=inc100(ConsVitFluxAir);
                    Wifi.printf("$B%u\r\n",ConsVitFluxAir);
                    lcd.locate(60,1);
                    lcd.printf("%03u%%\r\n",ConsVitFluxAir);//on affiche la consigne
                    break;
                case 'G' :
                    ConsVitFluxAir=dec0(ConsVitFluxAir);
                    Wifi.printf("$B%u\r\n",ConsVitFluxAir);
                    lcd.locate(60,1);
                    lcd.printf("%03u%%\r\n",ConsVitFluxAir);//on affiche la consigne
                    break;
                default :
                    ;
            }
        }
        if (NewFrequence==true) {
            Frequencehelice = FrequenceCalc;
            NewFrequence = false;
        }
        // acquisition des données toutes les secondes
        if (acquerir == true) {
            VitesseAir = EntVitesseAir.read();
            VitesseAir = VitesseAir*(72.0*2.0*3.46/5.0);//Avec N, on peut trouver VitesseAir
            // hum et temperature
            Temperature = capt.readTemperature();
            Humidite = capt.readHumidity();
            Wifi.printf("$Z,%0.0f,%0i,%0i\r\n",VitesseAir,Temperature,Humidite);
            affichage = true;
        }
        if (BoutonChange==true) {
            SetPwmMot(ConsVitFluxAir); // on peut commande moteur 50% max -> 15ms
            BoutonChange = false;
            lcd.locate(60,1);
            lcd.printf("%03u%%\r\n",ConsVitFluxAir);//on affiche la consigne
            Wifi.printf("$B%u\r\n",ConsVitFluxAir);
            // wait(0.001);
        }

        if (affichage == true) {
            lcd.locate(50,14);
            lcd.printf("%03.0fkm/h",VitesseAir);//on affiche la vitesse
            lcd.locate(60,27);
            lcd.printf("%03iC\r\n",Temperature);//on affiche la température
            lcd.locate(60,40);
            lcd.printf("%03i%%\r\n",Humidite);//on affiche l'humidité
            lcd.locate(60,53);
            lcd.printf("%03.0fHz\r\n",Frequencehelice);//on afiche la fréquence d'helice
            affichage = false;
        }
    }
}
