#include "mbed.h"
Serial pc(USBTX, USBRX); //tx, rx
DigitalOut myled(LED1);
pc.getc ();
 
int main()
{
    char dataBuffer[100]; //define a variable of type array character
    
    while(1)  {
        if(pc.readable()) {         //if there is a character in the serial buffer
            pc.scanf("%s",dataBuffer);        //read a string of characters into the buffer

    sscanf(dataBuffer,
                "$%5s,*%2s\r\n", //seperate into header (string), value (float), and checksum (string)
                header,
                &value,
                checksum);
    
    num = sscanf(dataBuffer,
                "$%5s,%d,%f,%f,*%2s\r\n", //separate into header (strings), value (float), and check (string)
                header,
                &value_1,
                &value_2,
                &value_3,
                checksum);


        if (!strcmp("GPRMC",header)) {              //if "GPRMC" is entered into the command window, it will recognize its a GPS command and print out the data     
    pc.printf("GPS message received: %s/r/n",dataBuffer);
    } 
    
        else if (!strcmp("IMUPO",header)) {             //if "IMUPO" is entered into the command window, it will recognize its a Motion command and print out the data
    pc.printf("Motion message received: %s/r/n",dataBuffer);
    } 
    
        else if (!strcmp("TEMPE",header)) {             //if "TEMPE is entered into the command window, it will recognize its a Time command and print out the data
    pc.printf("Time message received: %s/r/n",dataBuffer);
    
        else 
    pc.printf("Error: input not allowed");          //if neither a GPS, Motion or Time command are entered, it will display an error
    }   
    {
  }
} 

                
