/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "iBeaconService.h"
#include "UARTService.h"
#include "stdbool.h"

/**
 * For this demo application, populate the beacon advertisement load
 * with 2 AD structures: FLAG and MSD (manufacturer specific data).
 *
 * Reference:
 *  Bluetooth Core Specification 4.0 (Vol. 3), Part C, Section 11, 18
 */

BLEDevice ble;
UARTService *uart;

/**
 * The Beacon payload has the following composition:
 * 128-Bit / 16byte UUID = E2 0A 39 F4 73 F5 4B C4 A1 2F 17 D1 AD 07 A9 61
 * Major/Minor  = 0x1122 / 0x3344
 * Tx Power     = 0xC8 = 200, 2's compliment is 256-200 = (-56dB)
 *
 * Note: please remember to calibrate your beacons
 * TX Power for more accurate results.
 */
const uint8_t uuid[] = {0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4,
                        0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x62
                       };
uint16_t majorNumber = 1122;
uint16_t minorNumber = 3346;
uint16_t txPower = 0xC8;


const uint8_t b1_id   = 0x01;
const uint8_t bA1_id  = 0x31;


PinName sensor_pin         = P0_5;
PinName trigger_pin        = P0_10;

const _Bool turn_on = 0;
const _Bool turn_off = 1;

//setup led
DigitalOut led1(P0_19);

//setup digital ins/outs
DigitalIn digi_sensor(sensor_pin);
DigitalOut digi_trigger(trigger_pin);

//set interrupt pin
InterruptIn intrpt_sensor(sensor_pin);


void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason);
void onDataWritten(const GattCharacteristicWriteCBParams *params);
int flip(char value);
void testAll(void);
void signal_off(void);
void signal_on(void);

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising();
}

void onDataWritten(const GattCharacteristicWriteCBParams *params)
{

}

void signal_off(void)
{
    digi_trigger = turn_off;
    wait(.5);
    //ble.updateCharacteristicValue(readChar.getValueHandle(),"OFF",sizeof("OFF"));
}

void signal_on(void)
{
    digi_trigger = turn_on;
    wait(.5);
}


int main(void)
{
    /* initialize stuff */
    led1 = 1;

    
    ble.init();
    digi_trigger = turn_on;
    
    
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);
    uart = new UARTService(ble);    
    iBeaconService ibeacon(ble, uuid, majorNumber, minorNumber, txPower);
    ble.setAdvertisingInterval(1000); /* 1000ms. */
    ble.startAdvertising();

    while(1)
    {
        intrpt_sensor.rise(&signal_on);
        intrpt_sensor.fall(&signal_off);
        ble.waitForEvent(); // allows or low power operation
    }
}

void testAll(void)
{
    for(int i=0; i<2; i++)    
    {
        led1 = !led1;
        digi_trigger = !digi_trigger;
        wait(1);
    }
}

void blinky(void)
{
    for(int i=0; i<15; i++)    
    {
        led1 = !led1;
        wait(.3);
    }
}

int flip(char value)
{
    int ret = 0;
/*    
    
    switch(value)
    {
        // close door
        case b1_id  :
        case bA1_id :       led1 = !led1;
                            b1 = 1;
                            break;
        // open door
        case b2_id  :
        case bA2_id :       led1 = !led1;
                            b1 = 0;
                            break;
        // timed open 10 seconds
        case b3_id  :
        case bA3_id :       led1 = !led1;
                            b1 = 0;
                            wait(10);
                            b1 = 1;
                            break;
        // light 1 on
        case b4_id  :
        case bA4_id :       led1 = !led1;
                            b2 = 0;
                            break;
        // light 1 off
        case b5_id  :
        case bA5_id :       led1 = !led1;
                            b2 = 1;
                            break;
        // light 2 on
        case b6_id  :
        case bA6_id :       led1 = !led1;
                            b3 = 0;
                            break;
        // light 2 off
        case b7_id  :
        case bA7_id :       led1 = !led1;
                            b3 = 1;
                            break;
        // light 3 on
        case b8_id  :
        case bA8_id :       led1 = !led1;
                            b4 = 0;
                            break;
        // light 3 off
        case b9_id  :
        case bA9_id :       led1 = !led1;
                            b4 = 1;
                            break;
                            
        default :           blinky();
                            ret = 1;
                            break;
    }
*/
    return ret;
}