#include "mbed.h"
#include "BLEDevice.h"
#include "AltBeaconService.h"
#include "iBeaconService.h"


BLEDevice ble;
DigitalOut led(LED1);

/*..........................................................................
uint8_t beaconID[] =    {   0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4,
                            0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x61,
                            0x11, 0x22, 0x33, 0x44
                        };
uint16_t manufacturerID = 0x5900; //Nordic SIG ID
int8_t rssi = -122;
..........................................................................*/


uint8_t beaconID[] =    {   0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4,
                            0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x61
                        };
uint16_t majorNumber = 1122;
uint16_t minorNumber = 3344;
uint16_t txPower = 0xC8;


uint16_t customServiceUUID  = 0xA000;
uint16_t readCharUUID       = 0xA001;
uint16_t writeCharUUID      = 0xA002;
uint16_t A16                = 0xA005;





const uint8_t b1_id   = 0x01;
const uint8_t b2_id   = 0x02;
const uint8_t b3_id   = 0x03;
const uint8_t b4_id   = 0x04;
const uint8_t b5_id   = 0x05;
const uint8_t b6_id   = 0x06;
const uint8_t b7_id   = 0x07;
const uint8_t b8_id   = 0x08;

const uint8_t bA1_id  = 0x31;
const uint8_t bA2_id  = 0x32;
const uint8_t bA3_id  = 0x33;
const uint8_t bA4_id  = 0x34;
const uint8_t bA5_id  = 0x35;
const uint8_t bA6_id  = 0x36;
const uint8_t bA7_id  = 0x37;

PinName flood_p     = P0_4;
PinName b1_p        = P0_28;
PinName b2_p        = P0_29;
PinName b3_p        = P0_15;
PinName b4_p        = P0_10; //CTX
PinName b5_p        = P0_9;  //TXD
PinName b6_p        = P0_11; //RXD
PinName b7_p        = P0_8;  //RTS


/*
PinName b4_p             = CTX; //CTX
PinName b5_p             = TXD;  //TXD
PinName b6_p             = D0; //RXD
PinName b7_p             = D3;  //RTS
*/


const static char     DEVICE_NAME[]        = "PETE2"; // change this
static const uint16_t uuid16_list[]        = {0xFF02}; //Custom UUID, FFFF is reserved for development


//setup custom characteristics

//read
static uint8_t readValue[10] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(readValue)> readChar(readCharUUID, readValue);
//write
static uint8_t writeValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeValue)> writeChar(writeCharUUID, writeValue);


// Set up custom service
GattCharacteristic  *characteristics[] = {&readChar, &writeChar};
GattService         customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

//setup led
DigitalOut led1(P0_19);

//setup digital outs
DigitalOut b1(b1_p);
DigitalOut b2(b2_p);
DigitalOut b3(b3_p);
DigitalOut b4(b4_p);
DigitalOut b5(b5_p);
//DigitalOut b6(b6_p);
DigitalOut b7(b7_p);

DigitalIn enable(flood_p);


void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason);
void writeCharCallback(const GattCharacteristicWriteCBParams *params);
void testAll(void);
void blinky(void);
int flip(char value);


//main loop............................................................................................................
int main(void)
{
    /* initialize stuff */
    led1 = 1;
    
    b1 = 1;//b1_p = P0_28;
    b2 = 1;//b2_p = P0_29;
    b3 = 1;//b3_p = P0_9;
    b4 = 1;//b4_p = P0_10; //CTX
    b5 = 1;//b5_p = P0_9;  //TXD
    //b6 = 1;//b6_p = P0_11; //RXD
    b7 = 1;//b7_p = P0_8;  //RTS
              
    

    
    ble.init();
    
    //setup beacon service
    //AltBeaconService altbeacon(ble, manufacturerID, beaconID, rssi);
    iBeaconService ibeacon(ble, beaconID, majorNumber, minorNumber, txPower);
    
    
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(writeCharCallback);


    /* setup advertising */
    
    // BLE only, no classic BT
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    // advertising type
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    // add name
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    // UUID's broadcast in advertising packet
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    
    
    // set interval
    ble.setAdvertisingInterval(100); // 100ms. 

    // add our custom service
    ble.addService(customService);

    // start advertising
    ble.startAdvertising(); 
    
    // infinite loop waiting for BLE interrupt events
    while (true) {
        ble.waitForEvent(); //Save power
    }
}
//.......................end main............................................................................................

/*
 *  Restart advertising when phone app disconnects
*/ 
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); 
}

/* 
 *  handle writes to writeCharacteristic
*/
void writeCharCallback(const GattCharacteristicWriteCBParams *params)
{
    // check to see what characteristic was written, by handle
    if(params->charHandle == writeChar.getValueHandle()) 
    {
        //testAll();
        flip(params->data[0]);

        // update the readChar with the value of writeChar
        ble.updateCharacteristicValue(readChar.getValueHandle(),params->data,params->len);
    }
}

void testAll(void)
{
    for(int i=0; i<4; i++)    
    {
        led1 = !led1;
        b1 = !b1;
        b2 = !b2;
        b3 = !b3;
        b4 = !b4;
        b5 = !b5;
        //b6 = !b6;
        b7 = !b7;
        wait(1);
    }
}
void blinky(void)
{
    for(int i=0; i<20; i++)    
    {
        led1 = !led1;
        wait(.3);
    }
}
int flip(char value)
{
    int ret = 0;
    
    switch(value)
    {
        case b1_id  :
        case bA1_id :       led1 = !led1;
                            b1 = !b1;
                            break;
                            
        case b2_id  :
        case bA2_id :       led1 = !led1;
                            b2 = !b2;
                            break;
        
        case b3_id  :
        case bA3_id :       led1 = !led1;
                            b3 = !b3;
                            break;
        
        case b4_id  :
        case bA4_id :       led1 = !led1;
                            b4 = !b4;
                            break;
        
        case b5_id  :
        case bA5_id :       led1 = !led1;
                            b5 = !b5;
                            break;
        
        case b7_id  :
        case bA7_id :       led1 = !led1;
                            b7 = !b7;
                            break;
        
        default :           blinky();
                            ret = 1;
                            break;
    }
    return ret;
}