#include "mbed.h"

/* connect a "wedge" between an arbitrary digital pin (p5 in this example) and nR (pin4)*/

Serial pc(USBTX, USBRX);
DigitalInOut reset(p5);
LocalFileSystem local("local"); 
//FILE *fp;

int main() {

    pc.baud(115200);
    char filename[64];    
    int n = 0;

    while(1) {
        sprintf(filename, "/local/reset%03d.txt", n);   
        FILE *fp = fopen(filename, "r");               
        if(fp == NULL) {                                
            break;
        }
        fclose(fp);                                    
        n++;                                          
    }
    
    FILE *fp = fopen(filename, "w");
    fprintf(fp, "Reset # %d\n", n);
    fclose(fp);
    
    pc.printf("\nThis was reset # %u\n", n);  
    pc.printf("Press 'R' to reset (and reload) the target\n");
    
    while(1) {
        if (pc.readable()){
            char c = pc.getc();
            if(c== 'R'){
                pc.printf("\nReset! Bye, bye...\n");
                reset.output();
/*              reset.write(0);   not necessary*/
            }
            else pc.printf("Got %c\n",c); 
        }
    }
}    