#include "mb_pins.h"
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"
#include <cstring>
 
#define SMALL_WAIT_MS            10
 
#define BLINK_PERIOD_MS         250
 
//OLED DIMENSIONS
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128

//I2C adress
#define I2C_ADDRESS         0x3c
#define I2C_ADD_MBED    I2C_ADDRESS << 1

AnalogIn POT1(MB_POT1);
DigitalOut led2(MB_LED2);

TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
WiFiInterface *wifi;
 
I2C i2c_obj(MB_OLED_SDA, MB_OLED_SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);


char* topic_pub = "pubpim";
char* topic_sub = "subpim";
const char* hostname = "broker.hivemq.com";
int port = 1883;
 

 
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Browser message: %.*s \r\n", message.payloadlen, (char*)message.payload);
    
    myOLED.clearDisplay();
    myOLED.printf("%.*s \r", message.payloadlen, (char*)message.payload);
    myOLED.display();
}
 

 
int main()
{
    wifi = WiFiInterface::get_default_instance();
    if(!wifi)
        {
            printf("ERROR: Nema WiFija");
            return -1;
        }
    
    printf("\n Connecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0){
        printf("GRESKA u POVEZIVANJU \n");
        return -1;
    }
    
    printf("Success\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());
    
    socket.open(wifi);
    socket.connect(hostname, port);
    
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "YUSUF";
    
    int rc = 0;
    if((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d \r\n",rc);
    
    if((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)     //ovako se on subscribuje na temu
        printf("rc from MQTT subscribe is %d \r\n", rc);
       
    
    char dr[4] = {'o','l','e','d'};
    char strt[5] = {'s','t','a','r','t'};
    char stp[4] = {'s','t','o','p'};
    while(true)
    {
        led2 =! led2;
        thread_sleep_for(BLINK_PERIOD_MS);
            char buf[100];
            sprintf(buf, "rec je");
            
            
        /*    if (std::strcmp(buf, strt) == 0 && m==1) {
                sprintf(buf, "V(POT1) = %1.2f \r\n", POT1 * (3.3f));
                
                
                if (std::strcmp(buf, stp) == 0) {
                    sprintf(buf, "rec je");
                
                }  } 
      */      
            
            if (std::strcmp(buf, dr) == 0) {
                //ako jes
                myOLED.begin(); //pocetak
                i2c_obj.frequency(400000); //veca frekvencija slanja da ne bi ghostovalo
    
                 myOLED.clearDisplay();
                 myOLED.display();
                
            }
            
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic_pub, message);
        
        client.yield(1000);
        
    }
}