/* Za BONUS
 *   Odgovara jacini zvuka koji se cuje, ali uz treptanje brojeva,
 *   jer se vidi po osvetljenju crvene diode LED1
 */

/*
 * Uvoz biblioteka
 */
#include <mbed.h>

/*
 * Definisanje direktiva
 */
#define SKALIRANJE 200
#define Perioda 20
#define WAIT_MS 20
#define WAIT_MS2 1
#define WAIT_MS3 100
#define WAIT_MS4 2

/*
 * Glavne promenljive
 */
BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3);
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
PwmOut zujalica(PA_11);
InterruptIn sw1(PC_9);
DigitalOut SEL2(PC_7);
DigitalOut SEL1(PB_6);
int i;
/*
 * Dodatne funkcije
 */
void ISR_sw1(void);

/*
 * Glavna funkcija
 */

int main()
{
    
    zujalica.period_ms(Perioda);
    while(1)
    {
        
        zujalica.period(pot2.read() / SKALIRANJE);
        
        zujalica.write(pot1.read());
        printf("POT1  =  %1.2f \r\n", pot1.read()); //cisto provera da bi video kolika je vrednost POT1
       
              
        sw1.fall(&ISR_sw1); // kada se klikne prikaze se broj
                            // izvinjavam se zato sto je cifra desetica bas bas slabo osveltjena
        
    switch(i)
    {
        case 1: display.write(0x40); wait_ms(WAIT_MS); break;
        case 2: display.write(0x79); wait_ms(WAIT_MS); break;
        case 3: display.write(0x24); wait_ms(WAIT_MS); break;
        case 4: display.write(0x30); wait_ms(WAIT_MS); break;
        case 5: display.write(0x19); wait_ms(WAIT_MS); break;
        case 6: display.write(0x12); wait_ms(WAIT_MS); break;
        case 7: display.write(0x02); wait_ms(WAIT_MS); break;
        case 8: display.write(0x78); wait_ms(WAIT_MS);break;
        case 9: display.write(0x00); wait_ms(WAIT_MS);break;
        case 10: display.write(0x10); wait_ms(WAIT_MS); break; //0-9
        
        case 11: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); //10-99
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 12: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 13: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 14: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 15: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 16: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 17: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 18: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 19: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 20: SEL2.write(1); SEL1.write(0); display.write(0x79); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2);break;
      //==============================================================================================================
        case 21: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); //20
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 22: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 23: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 24: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 25: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 26: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 27: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 28: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 29: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 30: SEL2.write(1); SEL1.write(0); display.write(0x24); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
        //==============================================================================================================
        case 31: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); //30
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 32: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 33: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 34: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 35: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 36: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 37: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 38: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 39: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 40: SEL2.write(1); SEL1.write(0); display.write(0x30); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
        
        //==============================================================================================================
        case 41: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); //40
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 42: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 43: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 44: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 45: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 46: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 47: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 48: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 49: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 50: SEL2.write(1); SEL1.write(0); display.write(0x19); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
            
        //==============================================================================================================
        case 51: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); //50
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 52: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 53: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 54: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 55: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 56: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 57: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 58: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 59: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 60: SEL2.write(1); SEL1.write(0); display.write(0x12); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
        
         //==============================================================================================================
        case 61: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); //60
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 62: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 63: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 64: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 65: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 66: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 67: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 68: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 69: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 70: SEL2.write(1); SEL1.write(0); display.write(0x02); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
              //==============================================================================================================
        case 71: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); //70
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 72: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 73: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 74: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 75: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 76: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 77: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 78: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 79: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 80: SEL2.write(1); SEL1.write(0); display.write(0x78); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
                  //==============================================================================================================
        case 81: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); //80
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 82: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 83: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 84: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 85: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 86: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 87: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 88: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 89: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 90: SEL2.write(1); SEL1.write(0); display.write(0x00); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2); break;
            
                
                  //==============================================================================================================
        case 91: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); //90
            SEL1.write(1); 
            SEL2.write(0); display.write(0x40); wait_ms(WAIT_MS2);break;
        
        case 92: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x79); wait_ms(WAIT_MS2);break;
        
        case 93: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x24); wait_ms(WAIT_MS2);break;
            
        case 94: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x30); wait_ms(WAIT_MS2);break;
            
        case 95: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1);  
            SEL2.write(0); display.write(0x19); wait_ms(WAIT_MS2); break;
        
        case 96: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x12); wait_ms(WAIT_MS2);break; //15
            
        case 97: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x02); wait_ms(WAIT_MS2);break;
        
        case 98: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x78); wait_ms(WAIT_MS2);break;
        
        case 99: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS2); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x00); wait_ms(WAIT_MS2);break;
            
        case 100: SEL2.write(1); SEL1.write(0); display.write(0x10); wait_ms(WAIT_MS4); 
            SEL1.write(1); 
            SEL2.write(0); display.write(0x10); wait_ms(WAIT_MS2-0.5f); break; //99
        
        
    }    
        
    }
}

void ISR_sw1(void)
{
    
    i= pot1.read()*100 + 1; 
    
    
} 